# Модуль БИФИТ Кассы для Drupal Commerce 7.x

## Описание работы модуля

Данное решение позволяет подключить Ваш интернет-магазин к облачному сервису БИФИТ Касса с целью соответствия требованиям 54-ФЗ для регистрации расчетов с использованием электронного средства платежа в сети Интернет.

Возможности плагина

  - автоматическая фискализация платежей;
  - фискализация в ручном режиме.
  - синхронизация с кабинетом "БИФИТ Касса"

Описание работы

Плагин реагирует на событие оплаты заказа, которое возникает, когда клиент совершает оплату через один из подключенных модулей приема платежей, например, PayPal или Robokassa.

После оплаты заказа информации о заказе формируется и отправляется запрос на фискализацию платежа в систему БИФИТ Касса.

Как только данные по заказу появляются в системе БИФИТ Касса, формируется чек, который записывается на фискальный накопитель кассового аппарата и он же отправляется в ОФД (Оператор Фискальных Данных). 

Важно! 54-ФЗ обязует выдать электронный чек клиенту, для того чтобы электронный чек был выслан клиенту на электронную почту необходимо сделать обязательным поле email на форме оформления заказа.

Также можно включить функционал связи с кабинетом, чтобы заказы сайта сразу же передавались в личный кабинет "БИФИТ Касса". Для этого необходимо активировать параметры связи в настройках, а так же создать новый параметр "Телефон" в настройках аккаунта сайта. Псевдоним (machine name, машинное имя) данного поля обязательно должно быть в значении "field_phone" (подробнее в иснтрукции со скриншотами).

Список запросов на фискализацию можно посмотреть на вкладке «БИФИТ Касса» — «Отчеты» в разделе администратора магазина.

Таким образом вы можете использовать раздел администратора магазина для печати чека по любому заказу.

## Установка и настройка

Прежде чем приступить к установке  настройке модуля вам потребуется зарегистрировать в [личном кабинете на сайте БИФИТ Касса][kassa_bifit_registration].

Для настройки плагина, необходимо сделать следующее:

1. Авторизуемся на сайте.
2. В верхнем меню выбираем: Настройки сайта → Модули
3. На странице модулей нажимаем кнопку "Установить новый модуль"
4. На странице установки выбираем файл "commerce_bifitkassa.zip" и нажимаем кнопку "Установить".
5. После установки модуля возвращаемся на страницу модулей и: 
   5.1. В левой колонке нажимаем на пункт "Commerce (BIFIT Kassa)".
   5.2. Нажимаем на кнопку включения слева от названия модуля, чтобы она стала зеленой. В зависимости от шаблона, вместо кнопки может быть обычный чекбокс, который нужно отметить.
   5.3. Жмём на кнопку "Сохранить конфигурацию".
6. В меню справа от названия модуля, выбираем и нажимаем на ссылку "Конфигурация".
7. На странице настроек конфигурации: 
   7.1. Выбираем и заполняем нужные параметры:
        7.1.1.  Тестовый(*) или Боевой режим работы расширения.
        7.1.2.  Заполняем полученный токен доступа необходимый для боевого режима работы.
        7.1.3.  Вводим фамилию и инициалы кассира, например Иванов И.И.
        7.1.4.  Вводим ИНН кассира (12-ть цифр для РФ).
        7.1.5.  Вводим место расчёта → домен сайта, строго по форме (с http или https): https://site.ru
        7.1.6.  Выбираем, что выводить в адресе клиента: телефон или e-mail.
        7.1.7.  Выбираем признак способа расчёта.
        7.1.8.  Выбираем тип оплаты.
        7.1.9.  Выбираем режим назначения НДС.
        7.1.10. Выбираем ставку НДС.
        7.1.11. Далее идут четыре одинаковых набора параметров для разных типов документов: "Приход", "Возврат прихода", "Расход", "Возврат расхода".
                7.1.11.1. Выбираем использовать или нет данный тип документа. 
                7.1.11.2. Выбираем учитывать или нет параметр "Заказ оплачен".
                7.1.11.3. Выбираем систему налогообложения.
                7.1.11.4. Выбираем один или несколько статусов заказа, при выборе которых будет активирована работа расширения по данной вкладке.
                7.1.11.5. Выбираем один или несколько способов оплаты, при выборе которых будет активирована работа расширения по данной вкладке.
   7.2. Сохраняем изменённые параметры нажатием на кнопку "Сохранить конфигурацию" внизу страницы. 
   
8. Справа вверху две вкладки: первая "Настройки", с текущими настройками, вторая "Отчёты", где будут отображаться все проведённые транзакции.

## ТЕЛЕФОН

В CMS "Drupal 7" по-умолчанию нет параметра для ввода телефона. Поэтому для полноценной работы функционала синхронизации сайта с кабинетом "БИФИТ Касса", потребуется создать поле для ввода номера телефона. Для этого необходимо: 
1. Открыть страницу настроек аккаунта по пути: Конфигурация → Настройки → Конфигурация → Пользователи → Настройки учётной записи. Открыть вкладку "Управление полями" и добавить новое поле с названием "Телефон", обязательным(!) машинным именем "field_phone" и типом поля "Текст".
2. Далее открыть вкладку "Редактировать" (нового параметра "Телефон") и сделать его обязательным (отметить соответствующий чекбокс).
3. При необходимости (не обязательно), Вы можете добавить уже созданное поле "Телефон" в список параметров адреса доставки и оплаты. Для этого нужно открыть страницу по пути: Магазин → Конфигурация → Профили клиентов → Типы профилей. Нажать на ссылку "управление полями" у каждого профиля.
4. Добавить уже созданное поле "Телефон" (не новое, а именно уже созданное).

[kassa_bifit_registration]: https://kassa.bifit.com/cashdesk/#/auth/registration