<?php

function bifitkassa_fiscalize($order, $test, $token, $i)
{
	if (empty($order->order_id)) {
		return;
	}

	// params
	$wrapper = entity_metadata_wrapper("commerce_order", $order->order_id);
	$default_pid = commerce_addressbook_get_default_profile_id(
		$order->uid,
		"shipping"
	);
	$profile_load = commerce_customer_profile_load($default_pid);
	$profile = $profile_load->commerce_customer_address["und"][0];

	// user
	$user_phone = commerce_bifitkassa_check_phone(
		$profile_load->field_phone["und"][0]["value"]
	);
	$user_email = commerce_bifitkassa_check_email($wrapper->mail->value());

	// 1. AUTHORIZATION
	//    process necessary to connect a client to fiscal processing

	// address for POST request
	$url = "https://fp" . $test . ".bifit.com/processing-api/oauth/token";

	// link data
	$data = "token=" . $token;
	$data .= "&client_id=processing-connector-token";
	$data .= "&client_secret=processing-connector-token";
	$data .= "&grant_type=token";

	// headers
	$headers = ["Content-Type: application/x-www-form-urlencoded"];

	// decode the received json response
	$bifit = json_decode(commerce_bifitkassa_get_data($url, $headers, $data));

	// 2. FORMATION OF THE CONTENT OF A CHECK
	//    formation of information for further sending for fiscalization

	// Plugin parameters

	// cashier name
	$cashier_name = variable_get("commerce_bifitkassa_cashier_name", "");
	// TIN of the cashier
	$cashier_inn = variable_get("commerce_bifitkassa_cashier_inn", "");
	// document type
	$arr_rec_type = [
		"1" => "SALE",
		"2" => "SALE_RETURN",
		"3" => "PURCHASE",
		"4" => "PURCHASE_RETURN",
	];
	$receipt_type = $arr_rec_type[$i];
	// tax system
	$tax_system = variable_get(
		"commerce_bifitkassa_tax_system_" . $i,
		"SIMPLIFIED_WITH_EXPENSE"
	);
	// method of calculation
	$calc_method = variable_get(
		"commerce_bifitkassa_calculation_method",
		"FULL_PAY"
	);
	// uniform VAT
	$vat_mode = variable_get("commerce_bifitkassa_vat_mode", "1");
	// VAT
	$vat = variable_get("commerce_bifitkassa_vat", "WITHOUT_VAT");
	// payment type
	$payment_type = variable_get("commerce_bifitkassa_payment_type", "CARD");
	// place of settlement
	$payment_address = variable_get(
		"commerce_bifitkassa_payment_address",
		"https://site.ru"
	);
	// client address type
	$address_type = variable_get("commerce_bifitkassa_address_type", "email");
	// address
	$address = $address_type == "email" ? $user_email : $user_phone;

	// order data
	/// order id
	$order_id = (int) $order->order_id;
	/// order number
	$order_number = $order->order_number;
	/// order total
	$commerce_order_total = $wrapper->commerce_order_total->value();
	$order_total = (float) number_format(
		$commerce_order_total["amount"] / 100,
		2,
		".",
		""
	);

	// order payment items
	$o_subtotal = 0;
	$o_discount = 0;
	$o_shipment = 0;
	$o_total = 0;
	$shipment_tax_percent = "";

	// array parameters
	/// an array of products to fill
	$r_products = [];

	// key of the array of goods for the receipt
	$key_id = 0;

	foreach ($wrapper->commerce_line_items as $key => $line_item_wrapper) {
		$line_item_type = $line_item_wrapper->getBundle();
		$item_sum = commerce_bifitkassa_get_amount(
			$line_item_wrapper->commerce_total
		);
		$item_price = commerce_bifitkassa_get_amount(
			$line_item_wrapper->commerce_unit_price
		);
		$item_quantity = commerce_bifitkassa_get_quantity($line_item_wrapper);

		if (in_array($line_item_type, commerce_product_line_item_types())) {
			$item_name = $line_item_wrapper->commerce_product->value()->title;
		} else {
			$item_name = $line_item_wrapper->line_item_label->value();
		}

		if ($line_item_type == "product") {
			// we clear the name of the product from special characters
			$p_name = preg_replace(
				"/[^\p{L}0-9\-]/iu",
				" ",
				html_entity_decode($item_name)
			);
			$p_name = preg_replace("/ +/", " ", trim($p_name));

			// product codes
			$item_id = $line_item_wrapper->commerce_product->value()
				->product_id;
			$item_ean = $line_item_wrapper->line_item_label->value();

			// tax_rate
			$tax_rate = commerce_bifitkassa_get_tax_rate($line_item_wrapper);

			// form an array of goods for the check
			$r_products[$key_id] = new stdClass();
			$r_products[$key_id]->product_id = $item_id;
			$r_products[$key_id]->product_name = $p_name;
			$r_products[$key_id]->product_item_price = $item_price;
			$r_products[$key_id]->product_quantity = $item_quantity;
			$r_products[$key_id]->product_full_price = $item_sum;
			$r_products[$key_id]->product_vendor_code = $item_ean;
			$r_products[$key_id]->product_tax =
				$tax_rate > 0 ? "VAT_" . $tax_rate : "WITHOUT_VAT";
			$key_id++;

			$o_subtotal += $item_sum;
		}

		if ($line_item_type == "commerce_discount") {
			$o_discount += $item_sum < 0 ? abs($item_sum) : $item_sum;
		}

		if ($line_item_type == "shipping") {
			$o_shipment += $item_sum;
			$tax_rate = commerce_bifitkassa_get_tax_rate($line_item_wrapper);
			$shipment_tax_percent =
				$tax_rate > 0 ? "VAT_" . $tax_rate : "WITHOUT_VAT";
		}

		$o_total += $item_sum;
	}

	// check parameters
	$items = "";

	// generate check data
	foreach ($r_products as $key_id => $product) {
		// display the product data in the check
		$items .= $items != "" ? ", " : "";
		$items .= "{";
		$items .= '"calculationMethod":"' . $calc_method . '", ';
		$items .= '"paymentSubject":"PRODUCT", ';
		$items .= '"name":"' . $product->product_name . '", ';
		$items .=
			'"price":' .
			commerce_bifitkassa_check_price(
				$product->product_item_price,
				$o_subtotal,
				$o_discount
			) .
			", ";
		$items .= '"quantity":' . $product->product_quantity . ", ";
		$items .=
			$vat_mode == 1
				? '"vat":"' . $vat . '", '
				: '"vat":"' . $product->product_tax . '", ';
		$items .=
			'"total":' .
			commerce_bifitkassa_check_price(
				$product->product_full_price,
				$o_subtotal,
				$o_discount
			);
		$items .= "}";
	}

	// delivery
	if ($o_shipment > 0) {
		// display the data of the delivery method in the check
		$items .= $items != "" ? "," : "";
		$items .= "{";
		$items .= '"calculationMethod":"' . $calc_method . '",';
		$items .= '"paymentSubject":"SERVICE",';
		$items .= '"name":"' . t("Доставка") . '",';
		$items .= '"price":' . $o_shipment . ",";
		$items .= '"quantity":1,';
		$items .=
			$vat_mode == 1
				? '"vat":"' . $vat . '",'
				: '"vat":"' . $shipment_tax_percent . '",';
		$items .= '"total":' . $o_shipment;
		$items .= "}";
	}

	// form a check
	$receipt = "{";
	$receipt .=
		'"type":"' . $receipt_type . '","taxSystem":"' . $tax_system . '",';
	$receipt .= '"cashier":{';
	$receipt .= '"name":"' . $cashier_name . '",';
	$receipt .=
		'"inn":"' . commerce_bifitkassa_check_inn($cashier_inn, 1) . '"';
	$receipt .= "}, ";
	$receipt .= '"client":{';
	$receipt .= '"address":"' . $address . '"';
	$receipt .= "},";
	$receipt .= '"paymentAddress":"' . $payment_address . '",';
	$receipt .= '"items":[' . $items . "],";
	$receipt .= '"total":' . $order_total . ",";
	$receipt .= '"payments":{"' . $payment_type . '":' . $order_total . "}";
	$receipt .= "}";

	// 3. SENDING A CHECK TO FISCAL PROCESSING
	//    transfer of the content of the check to fiscal processing for further fiscalization

	// address for POST request
	$url =
		"https://fp" .
		$test .
		".bifit.com/processing-api/protected/documents/registration/receipts";

	// check data
	$data = $receipt;

	// Idempotency-Key
	$o = [];
	$o["number"] = $order_number;
	$o["summ"] = $order_total;
	$o["cms"] = "Drupal";
	$idemp_key = commerce_bifitkassa_create_guid($o);

	// headers
	$headers = [
		"Content-Type: application/json",
		"Authorization: Bearer " . $bifit->access_token,
		"Idempotency-Key: " . $idemp_key,
	];

	// get the ID of the document being processed (id)
	$receipt_id = json_decode(
		commerce_bifitkassa_get_data($url, $headers, $data)
	);

	// 4. RECEIVING DOCUMENT BY ID
	//    obtaining a document with fiscal characteristics by its number

	// options
	$doc = "";

	if (!is_object($receipt_id)) {
		// link for GET request
		$url =
			"https://fp" .
			$test .
			".bifit.com/processing-api/protected/documents/" .
			$receipt_id;

		// headers
		$headers = ["Authorization: Bearer " . $bifit->access_token];

		// we get the document
		$doc = json_decode(
			commerce_bifitkassa_get_data($url, $headers, false, "GET")
		);
	}

	// LINK TO THE CHECK

	// we form a link to the check
	$receipt_link = !is_object($receipt_id)
		? "https://fp" .
			$test .
			".bifit.com/processing-api/receipts/" .
			$idemp_key
		: "XXX";

	// OPERATION HISTORY

	// object parameters
	$object = new stdClass();
	/// order id
	$object->order_id = $order_id;
	/// order number
	$object->order_number = $order_number;
	/// order date
	$object->order_date = $order->created;
	/// date of operation
	$object->action_date = time();
	/// link to check
	$object->receipt_link = $receipt_link;
	/// id of the received document
	$object->receipt_id = !is_object($receipt_id) ? $receipt_id : "0";
	/// type of document being held
	$object->receipt_type = $receipt_type;
	/// operation log (to be filled in later)
	$object->log = "";

	// save the operation to history
	commerce_bifitkassa_save_report(
		$test,
		$bifit,
		$receipt,
		$receipt_id,
		$doc,
		$object,
		$idemp_key
	);
}

/* hook_commerce_order_presave */
function commerce_bifitkassa_commerce_order_presave($order)
{
	$test = variable_get("commerce_bifitkassa_test") ? "-test" : "";
	$token =
		$test != ""
			? "P5cKbUUD9uSSrSlGdzspLblvBnD0GzTAE0cLmAPSEMxJ79DtLE"
			: variable_get("commerce_bifitkassa_token");

	$status_id = $order->status;
	$payment_id = isset($order->data["payment_method"])
		? explode("|", $order->data["payment_method"])
		: null;
	$payed =
		isset($order->data["commerce_payment_order_paid_in_full_invoked"]) &&
		(int) $order->data["commerce_payment_order_paid_in_full_invoked"] == 1
			? 1
			: null;

	for ($i = 1; $i <= 5; $i++) {
		$use_type = variable_get("commerce_bifitkassa_use_type_" . $i);

		if ($use_type) {
			$order_paid = variable_get("commerce_bifitkassa_order_paid_" . $i);
			$pm_statuses = variable_get(
				"commerce_bifitkassa_pm_statuses_" . $i
			);
			$pm_ids = variable_get("commerce_bifitkassa_pm_ids_" . $i);
			$use_refused = variable_get(
				"commerce_bifitkassa_lk_use_refused",
				null
			);

			if ($i == 5 && $use_refused) {
				$lk_refused_statuses = variable_get(
					"commerce_bifitkassa_lk_refused_statuses",
					[]
				);

				if (
					isset($lk_refused_statuses) &&
					is_array($lk_refused_statuses) &&
					in_array($status_id, $lk_refused_statuses)
				) {
					$pm_statuses = array_merge(
						$pm_statuses,
						$lk_refused_statuses
					);
				}
			}

			if (
				isset($pm_ids) &&
				isset($pm_statuses) &&
				isset($payment_id) &&
				count(array_diff($payment_id, $pm_ids)) &&
				in_array($status_id, $pm_statuses) &&
				$token != ""
			) {
				if (isset($order_paid) && $order_paid != "-1" && !$payed) {
					continue;
				}

				if ($i == 5) {
					$lk = commerce_bifitkassa_get_LkData($order, $i);
					commerce_bifitkassa_save_order($lk);
				} else {
					bifitkassa_fiscalize($order, $test, $token, $i);
				}
			}
		}
	}
}
