<?php

function bifitkassa_reports()
{
	drupal_add_css(
		drupal_get_path("module", "commerce_bifitkassa") .
			"/assest/css/commerce_bifitkassa.ui.theme.css"
	);

	drupal_add_js("/misc/ui/jquery.ui.core.min.js");
	drupal_add_js("/misc/ui/jquery.ui.widget.min.js");
	drupal_add_js("/misc/ui/jquery.ui.dialog.min.js");

	$header = [
		["data" => t("ID"), "field" => "id"],
		["data" => t("ID заказа"), "field" => "order_id"],
		["data" => t("Номер заказа"), "field" => "order_number"],
		["data" => t("Дата заказа"), "field" => "order_date"],
		["data" => t("Дата запроса"), "field" => "action_date"],
		["data" => t("Чек"), "field" => "receipt_link"],
		["data" => t("Документ"), "field" => "receipt_id"],
		["data" => t("Лог"), "field" => "log"],
		["data" => t("Тип"), "field" => "receipt_type"],
	];

	$select = db_select("commerce_bifitkassa_reports", "reports")
		->extend("PagerDefault")
		->extend("TableSort");
	$select
		->fields("reports", [
			"id",
			"order_id",
			"order_number",
			"order_date",
			"action_date",
			"receipt_link",
			"receipt_id",
			"receipt_type",
			"log",
		])
		->limit(10)
		->orderByHeader($header)
		->orderBy("id", "desc");

	$results = $select->execute();
	$rows = [];

	if (is_object($results) && count((array) $results)) {
		foreach ($results as $key => $row) {
			$rows[] = [
				"id" => $row->id,
				"order_id" => bifitkassa_order_link($row->order_id),
				"order_number" => "№" . $row->order_number,
				"order_date" => bifitkassa_display_date($row->order_date),
				"action_date" => bifitkassa_display_date($row->action_date),
				"receipt_link" => bifitkassa_receipt_link($row->receipt_link),
				"receipt_id" => bifitkassa_receipt_id($row->receipt_id),
				"log" => bifitkassa_log_link($row->log, $key),
				"receipt_type" => bifitkassa_receipt_type(
					$row->receipt_type,
					$row->receipt_id
				),
			];
		}
	} else {
		return '<div class="messages warning">' .
			t("Нет сохранённых транзакций") .
			"...</div>";
	}

	$table = theme("table", ["header" => $header, "rows" => $rows]);
	$table .= theme("pager");

	return $table;
}
