<?php

function bifitkassa_settings_form($form, &$form_state)
{
	drupal_add_css(
		drupal_get_path("module", "commerce_bifitkassa") .
			"/assest/css/commerce_bifitkassa.theme.css"
	);

	drupal_add_js(
		drupal_get_path("module", "commerce_bifitkassa") .
			"/assest/js/commerce_bifitkassa.theme.js"
	);

	$form = [];

	$form["commerce_bifitkassa_test"] = [
		"#type" => "select",
		"#title" => t("Тестовый режим"),
		"#options" => bifitkassa_yes_no(),
		"#default_value" => variable_get("commerce_bifitkassa_test", "1"),
		"#required" => true,
	];

	$form["commerce_bifitkassa_token"] = [
		"#type" => "textfield",
		"#title" => t("Токен доступа"),
		"#default_value" => variable_get("commerce_bifitkassa_token", ""),
		"#required" => true,
	];

	$form["commerce_bifitkassa_cashier_name"] = [
		"#type" => "textfield",
		"#title" => t("ФИО кассира"),
		"#default_value" => variable_get(
			"commerce_bifitkassa_cashier_name",
			""
		),
		"#required" => true,
	];

	$form["commerce_bifitkassa_cashier_inn"] = [
		"#type" => "textfield",
		"#title" => t("ИНН кассира"),
		"#default_value" => variable_get("commerce_bifitkassa_cashier_inn", ""),
		"#required" => true,
	];

	$form["commerce_bifitkassa_payment_address"] = [
		"#type" => "textfield",
		"#title" => t("Место расчётов"),
		"#default_value" => variable_get(
			"commerce_bifitkassa_payment_address",
			"https://site.ru"
		),
		"#required" => true,
	];

	$form["commerce_bifitkassa_address_type"] = [
		"#type" => "select",
		"#title" => t("Адрес клиента"),
		"#options" => bifitkassa_address_type(),
		"#default_value" => variable_get(
			"commerce_bifitkassa_address_type",
			"email"
		),
		"#required" => true,
	];

	$form["commerce_bifitkassa_calculation_method"] = [
		"#type" => "select",
		"#title" => t("Признак способа расчёта"),
		"#options" => bifitkassa_calculation_method(),
		"#default_value" => variable_get(
			"commerce_bifitkassa_calculation_method",
			"PREPAY_FULL"
		),
		"#required" => true,
	];

	$form["commerce_bifitkassa_payment_type"] = [
		"#type" => "select",
		"#title" => t("Тип оплаты"),
		"#options" => bifitkassa_payment_type(),
		"#default_value" => variable_get(
			"commerce_bifitkassa_payment_type",
			"CASH"
		),
		"#required" => true,
	];

	$form["commerce_bifitkassa_vat_mode"] = [
		"#type" => "select",
		"#title" => t("Единый НДС"),
		"#options" => bifitkassa_yes_no(),
		"#default_value" => variable_get("commerce_bifitkassa_vat_mode", "1"),
		"#required" => true,
	];

	$form["commerce_bifitkassa_vat"] = [
		"#type" => "select",
		"#title" => t("Ставка НДС"),
		"#options" => bifitkassa_vat(),
		"#default_value" => variable_get(
			"commerce_bifitkassa_vat",
			"WITHOUT_VAT"
		),
		"#required" => true,
	];

	$arr = [
		"1" => t("Приход"),
		"2" => t("Возврат прихода"),
		"3" => t("Расход"),
		"4" => t("Возврат расхода"),
		"5" => t("Связь с кабинетом"),
	];

	foreach ($arr as $key => $name) {
		$form["commerce_bifitkassa_use_type_" . $key] = [
			"#type" => "select",
			"#title" => "<hr><h3>" . t($name) . "</h3>",
			"#options" => bifitkassa_yes_no(),
			"#default_value" => variable_get(
				"commerce_bifitkassa_use_type_" . $key,
				"0"
			),
		];

		$form["commerce_bifitkassa_order_paid_" . $key] = [
			"#type" => "select",
			"#title" => t("Заказ оплачен"),
			"#options" => bifitkassa_yes_no_not(),
			"#default_value" => variable_get(
				"commerce_bifitkassa_order_paid_" . $key,
				"-1"
			),
		];

		$form["commerce_bifitkassa_tax_system_" . $key] = [
			"#type" => "select",
			"#title" => t("Система налогообложения"),
			"#options" => bifitkassa_tax_system(),
			"#default_value" => variable_get(
				"commerce_bifitkassa_tax_system_" . $key,
				"0"
			),
		];

		$form["commerce_bifitkassa_pm_ids_" . $key] = [
			"#type" => "select",
			"#title" => t("Способ(ы) оплаты"),
			"#options" => bifitkassa_pm_ids(),
			"#multiple" => true,
			"#default_value" => variable_get(
				"commerce_bifitkassa_pm_ids_" . $key,
				"0"
			),
		];

		$form["commerce_bifitkassa_pm_statuses_" . $key] = [
			"#type" => "select",
			"#title" => t("Статус заказа"),
			"#options" => bifitkassa_pm_statuses(),
			"#multiple" => true,
			"#default_value" => variable_get(
				"commerce_bifitkassa_pm_statuses_" . $key,
				"0"
			),
		];
	}

	$form["commerce_bifitkassa_login"] = [
		"#type" => "textfield",
		"#title" => t("Логин"),
		"#default_value" => variable_get("commerce_bifitkassa_login", ""),
	];

	$form["commerce_bifitkassa_password"] = [
		"#type" => "textfield",
		"#title" => t("Пароль"),
		"#default_value" => variable_get("commerce_bifitkassa_password", ""),
	];

	$login = variable_get("commerce_bifitkassa_login", null);
	$password = variable_get("commerce_bifitkassa_password", null);

	if ($login && $password) {
		$form["commerce_bifitkassa_organization"] = [
			"#type" => "select",
			"#title" => t("Организация"),
			"#options" => bifitkassa_organization(),
			"#default_value" => variable_get(
				"commerce_bifitkassa_organization",
				""
			),
			"#ajax" => [
				"callback" => "bifitkassa_trade_object_update",
				"wrapper" => "replace_trade_object_div",
			],
			"#prefix" => '<div id="replace_organization_div">',
		];

		$form["commerce_bifitkassa_trade_object"] = [
			"#type" => "select",
			"#title" => t("Торговый объект"),
			"#options" => bifitkassa_organization(
				1,
				!empty(
					$form_state["values"]["commerce_bifitkassa_organization"]
				)
					? $form_state["values"]["commerce_bifitkassa_organization"]
					: null
			),
			"#default_value" => variable_get(
				"commerce_bifitkassa_trade_object",
				""
			),
			"#prefix" => '<div id="replace_trade_object_div">',
			"#suffix" => "</div></div>",
		];

		$form["commerce_bifitkassa_link"] = [
			"#type" => "button",
			"#value" => t("Обновить организации и объекты"),
			"#ajax" => [
				"callback" => "bifitkassa_organization_update",
				"wrapper" => "replace_organization_div",
				"method" => "replace",
				"effect" => "fade",
			],
			"#attributes" => [
				"title" => t(
					"Для ускорения работы и снятия лишней нагрузки на сервер онлайн-кассы, после первого успешного соединения с кабинетом, данные по оргиназациям и торговым объектам сохраняются в базу данных сайта. Нажмите эту кнопку для повторного соединения и обновления сохранённых данных."
				),
			],
		];

		$form["commerce_bifitkassa_lk_courier_delivery"] = [
			"#type" => "select",
			"#title" => t('Доставка "Курьером"'),
			"#options" => bifitkassa_deliveries(),
			"#multiple" => true,
			"#size" => bifitkassa_deliveries_count(),
			"#default_value" => variable_get(
				"commerce_bifitkassa_lk_courier_delivery",
				"0"
			),
		];

		$form["commerce_bifitkassa_lk_self_delivery"] = [
			"#type" => "select",
			"#title" => t('Доставка "Самовывоз"'),
			"#options" => bifitkassa_deliveries(),
			"#multiple" => true,
			"#size" => bifitkassa_deliveries_count(),
			"#default_value" => variable_get(
				"commerce_bifitkassa_lk_self_delivery",
				"0"
			),
		];

		$form["commerce_bifitkassa_lk_new_courier_order_status"] = [
			"#type" => "select",
			"#title" => t('Статус для нового заказа "Курьером"'),
			"#options" => [
				"new" => t("[NEW] Новый"),
				"accepted" => t("[ACCEPTED] Подтверждён"),
				"distributed" => t("[DISTRIBUTED] Распределён"),
			],
			"#default_value" => variable_get(
				"commerce_bifitkassa_lk_new_courier_order_status",
				"new"
			),
		];

		$form["commerce_bifitkassa_lk_use_refused"] = [
			"#type" => "select",
			"#title" => t("Удалять заказ в кабинете	"),
			"#options" => bifitkassa_yes_no(),
			"#default_value" => variable_get(
				"commerce_bifitkassa_lk_use_refused",
				"0"
			),
		];

		$form["commerce_bifitkassa_lk_refused_statuses"] = [
			"#type" => "select",
			"#title" => t("Статус заказа для удаления"),
			"#options" => bifitkassa_pm_statuses(),
			"#multiple" => true,
			"#default_value" => variable_get(
				"commerce_bifitkassa_lk_refused_statuses",
				"0"
			),
		];
	}

	return system_settings_form($form);
}
