<?php
/**
 * @version     5.0.1
 * @package     Jshopping.Plugin
 * @subpackage  bifit
 *
 * @copyright   Copyright (C) 2021—2026 BIFIT. All rights reserved.
 * @license     GNU General Public License version 2 or later
 */

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\Component\Jshopping\Site\Lib\JSFactory;

\defined('_JEXEC') or die();

class JFormFieldPayments extends JFormField
{
	protected $type = 'payments';

	public function getInput()
	{
		if (
			!file_exists(JPATH_SITE . "/components/com_jshopping/bootstrap.php")
		) {
			Factory::getApplication()->enqueueMessage(
				Text::_('PLG_JSHOPPING_BIFIT_WARNING'),
				'error'
			);
		} else {
			require_once JPATH_SITE . "/components/com_jshopping/bootstrap.php";

			$pm = JSFactory::getTable('paymentmethod');
			$paymethods = $pm->getAllPaymentMethods(0, 0);

			$name = $this->name . '[]';
			$value = empty($this->value) ? '' : $this->value;
			$size = count($paymethods) > 1 ? count($paymethods) : 2;

			return HTMLHelper::_(
				'select.genericlist',
				$paymethods,
				$name,
				'class="form-select" id="paymethods" size="' .
					$size .
					'"  multiple="multiple"',
				'payment_id',
				'name',
				$value
			);
		}
	}
}
