<?php
/**
 * @version     5.0.1
 * @package     Jshopping.Plugin
 * @subpackage  bifit
 *
 * @copyright   Copyright (C) 2021—2026 BIFIT. All rights reserved.
 * @license     GNU General Public License version 2 or later
 */

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\Component\Jshopping\Site\Lib\JSFactory;

\defined('_JEXEC') or die();

class JFormFieldStatuses extends JFormField
{
	protected $type = 'statuses';

	public function getInput()
	{
		if (
			!file_exists(JPATH_SITE . "/components/com_jshopping/bootstrap.php")
		) {
			Factory::getApplication()->enqueueMessage(
				Text::_('PLG_JSHOPPING_BIFIT_WARNING'),
				'error'
			);
		} else {
			require_once JPATH_SITE . "/components/com_jshopping/bootstrap.php";

			$lang = JSFactory::getLang();

			$db = Factory::getDBO();
			$query = $db->getQuery(true);
			$query
				->select(
					$db->quoteName(
						['status_id', 'status_code', $lang->get("name")],
						['status_id', 'status_code', 'name']
					)
				)
				->from(
					$db->quoteName($db->getPrefix() . 'jshopping_order_status')
				)
				->order($db->quoteName('status_id') . ' ASC');
			$db->setQuery($query);
			$statuses = $db->loadObJectList();
			$db->execute();

			$name = $this->name . '[]';
			$value = empty($this->value) ? '' : $this->value;
			$size = count($statuses) > 1 ? count($statuses) : 2;

			return HTMLHelper::_(
				'select.genericlist',
				$statuses,
				$name,
				'class="form-select" id="statuses" size="' .
					$size .
					'" multiple="multiple"',
				'status_id',
				'name',
				$value
			);
		}
	}
}
