<?php
/**
 * @version     5.0.1
 * @package     Jshopping.Plugin
 * @subpackage  bifit
 *
 * @copyright   Copyright (C) 2021—2026 BIFIT. All rights reserved.
 * @license     GNU General Public License version 2 or later
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;

\defined('_JEXEC') or die();

class PlgJshoppingBifitInstallerScript
{
	function install($parent)
	{
		// параметры
		$app = Factory::getApplication();
		$error = false;

		// подключаемся к базе данных сайта
		$db = Factory::getDbo();

		// получаем саписок всех таблиц БД
		$tables = $db->setQuery('SHOW TABLES')->loadColumn();

		// проверяем наличие в списке нужной таблицы
		if (!in_array($db->getPrefix() . 'jshopping_bifit_reports', $tables)) {
			$creaTabSql =
				'CREATE TABLE ' .
				$db->quoteName($db->getPrefix() . 'jshopping_bifit_reports') .
				' (' .
				$db->quoteName('id') .
				' int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,' .
				$db->quoteName('order_id') .
				' int(11) NOT NULL,' .
				$db->quoteName('order_number') .
				' varchar(50) NOT NULL,' .
				$db->quoteName('order_date') .
				' datetime DEFAULT NULL,' .
				$db->quoteName('action_date') .
				' datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,' .
				$db->quoteName('receipt_link') .
				' varchar(255) NOT NULL,' .
				$db->quoteName('receipt_id') .
				' int(11) NOT NULL,' .
				$db->quoteName('receipt_type') .
				' varchar(50) NOT NULL,' .
				$db->quoteName('log') .
				' text NOT NULL' .
				') ENGINE=InnoDB';

			if ($db->hasUTF8mb4Support()) {
				$creaTabSql =
					$creaTabSql .
					' DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;';
			} else {
				$creaTabSql =
					$creaTabSql .
					' DEFAULT CHARSET=utf8 DEFAULT COLLATE=utf8_unicode_ci;';
			}

			$db->setQuery($creaTabSql);
			$result = $db->execute();

			if ($result == true) {
				$app->enqueueMessage(
					Text::sprintf(
						'PLG_JSHOPPING_BIFIT_SUCCESS_CREATE_TABLE',
						'jshopping_bifit_reports'
					),
					'success'
				);
			} else {
				$app->enqueueMessage(
					Text::sprintf(
						'PLG_JSHOPPING_BIFIT_ERROR_CREATE_TABLE',
						'jshopping_bifit_reports'
					),
					'error'
				);
				$error = true;
			}
		}

		if ($error === true) {
			$app->enqueueMessage(
				Text::_('PLG_JSHOPPING_BIFIT_ERROR_INSTALLED'),
				'error'
			);
		} else {
			$app->enqueueMessage(
				Text::_('PLG_JSHOPPING_BIFIT_SUCCESS_INSTALLED'),
				'success'
			);
		}
	}

	function update($parent)
	{
		// параметры
		$app = Factory::getApplication();
		$error = false;

		// подключаемся к базе данных сайта
		$db = Factory::getDbo();

		// получаем список всех столбцов таблицы
		$columns = $db->getTableColumns(
			$db->getPrefix() . 'jshopping_bifit_reports'
		);

		// проверяем наличие в списке нужного столбца
		$column = 'cashier';
		if (array_key_exists($column, $columns)) {
			/// если обнаружен "старый" столбец, то обновляем таблицу до новой версии
			$query =
				'ALTER TABLE ' .
				$db->quoteName($db->getPrefix() . 'jshopping_bifit_reports') .
				'
				DROP ' .
				$db->quoteName('cashier') .
				',
				DROP ' .
				$db->quoteName('client') .
				',
				DROP ' .
				$db->quoteName('payment_type') .
				',
				DROP ' .
				$db->quoteName('doc') .
				';';
			$db->setQuery($query)->query();
			$query =
				'ALTER TABLE ' .
				$db->quoteName($db->getPrefix() . 'jshopping_bifit_reports') .
				' 
				ADD ' .
				$db->quoteName('action_date') .
				' DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP 
				AFTER ' .
				$db->quoteName('order_date') .
				';';
			$db->setQuery($query);
			$result = $db->execute();

			if ($result == true) {
				$app->enqueueMessage(
					Text::sprintf(
						'PLG_JSHOPPING_BIFIT_SUCCESS_UPDATE_TABLE',
						'jshopping_bifit_reports'
					),
					'success'
				);
			} else {
				$app->enqueueMessage(
					Text::sprintf(
						'PLG_JSHOPPING_BIFIT_ERROR_UPDATE_TABLE',
						'jshopping_bifit_reports'
					),
					'error'
				);
				$error = true;
			}
		}

		if ($error === true) {
			$app->enqueueMessage(
				Text::_('PLG_JSHOPPING_BIFIT_ERROR_UPDATED'),
				'error'
			);
		} else {
			$app->enqueueMessage(
				Text::_('PLG_JSHOPPING_BIFIT_SUCCESS_UPDATED'),
				'success'
			);
		}
	}

	function uninstall($parent)
	{
		// параметры
		$app = Factory::getApplication();
		$error = false;

		// подключаемся к базе данных сайта
		$db = Factory::getDbo();

		// получаем саписок всех таблиц БД
		$tables = $db->setQuery('SHOW TABLES')->loadColumn();

		// проверяем наличие в списке нужной таблицы
		if (in_array($db->getPrefix() . 'jshopping_bifit_reports', $tables)) {
			// удаляем таблицу плагина
			$dropTabSql =
				'DROP TABLE ' .
				$db->quoteName($db->getPrefix() . 'jshopping_bifit_reports');
			$db->setQuery($dropTabSql);
			$result = $db->execute();

			if ($result == true) {
				$app->enqueueMessage(
					Text::sprintf(
						'PLG_JSHOPPING_BIFIT_SUCCESS_DROP_TABLE',
						'jshopping_bifit_reports'
					),
					'success'
				);
			} else {
				$app->enqueueMessage(
					Text::sprintf(
						'PLG_JSHOPPING_BIFIT_ERROR_DROP_TABLE',
						'jshopping_bifit_reports'
					),
					'error'
				);
				$error = true;
			}
		}

		if ($error === true) {
			$app->enqueueMessage(
				Text::_('PLG_JSHOPPING_BIFIT_ERROR_UNINSTALLED'),
				'error'
			);
		} else {
			$app->enqueueMessage(
				Text::_('PLG_JSHOPPING_BIFIT_SUCCESS_UNINSTALLED'),
				'success'
			);
		}
	}
}
