<?php
class ControllerExtensionPaymentBifit extends Controller
{
	private $error = array();

	public function index()
	{
		// загрузка и подключение
		$this->load->language('extension/payment/bifit');
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('setting/setting');

		// обработка POST-запросов
		if (
			$this->request->server['REQUEST_METHOD'] == 'POST' &&
			$this->validate()
		) {
			$this->model_setting_setting->editSetting(
				'payment_bifit',
				$this->request->post
			);
			$this->session->data['success'] = $this->language->get(
				'text_success'
			);
			$this->response->redirect(
				$this->url->link(
					'marketplace/extension',
					'user_token=' .
						$this->session->data['user_token'] .
						'&type=payment',
					true
				)
			);
		}

		// данные предупреждения
		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		// данные ошибки токена
		if (isset($this->error['token'])) {
			$data['error_token'] = $this->error['token'];
		} else {
			$data['error_token'] = '';
		}

		// данные ошибки имени кассира
		if (isset($this->error['cashier_name'])) {
			$data['error_cashier_name'] = $this->error['cashier_name'];
		} else {
			$data['error_cashier_name'] = '';
		}

		// данные ошибки ИНН кассира
		if (isset($this->error['cashier_inn'])) {
			$data['error_cashier_inn'] = $this->error['cashier_inn'];
		} else {
			$data['error_cashier_inn'] = '';
		}

		// данные ошибки места рассчётов
		if (isset($this->error['payment_address'])) {
			$data['error_payment_address'] = $this->error['payment_address'];
		} else {
			$data['error_payment_address'] = '';
		}

		// Хлебные крошки
		$data['breadcrumbs'] = array();
		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link(
				'common/dashboard',
				'user_token=' . $this->session->data['user_token'],
				true
			)
		);
		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link(
				'marketplace/extension',
				'user_token=' .
					$this->session->data['user_token'] .
					'&type=payment',
				true
			)
		);
		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link(
				'extension/payment/bifit',
				'user_token=' . $this->session->data['user_token'],
				true
			)
		);
		$data['action'] = $this->url->link(
			'extension/payment/bifit',
			'user_token=' . $this->session->data['user_token'],
			true
		);
		$data['cancel'] = $this->url->link(
			'marketplace/extension',
			'user_token=' .
				$this->session->data['user_token'] .
				'&type=payment',
			true
		);

		// значение параметра"Тестирование""
		if (isset($this->request->post['payment_bifit_test'])) {
			$data['payment_bifit_test'] =
				$this->request->post['payment_bifit_test'];
		} else {
			$data['payment_bifit_test'] = $this->config->get(
				'payment_bifit_test'
			);
		}

		// значение параметра "Токен"
		if (isset($this->request->post['payment_bifit_token'])) {
			$data['payment_bifit_token'] =
				$this->request->post['payment_bifit_token'];
		} else {
			$data['payment_bifit_token'] = $this->config->get(
				'payment_bifit_token'
			);
		}

		// значение параметра "Имя кассира"
		if (isset($this->request->post['payment_bifit_cashier_name'])) {
			$data['payment_bifit_cashier_name'] =
				$this->request->post['payment_bifit_cashier_name'];
		} else {
			$data['payment_bifit_cashier_name'] = $this->config->get(
				'payment_bifit_cashier_name'
			);
		}

		// значение параметра "ИНН кассира"
		if (isset($this->request->post['payment_bifit_cashier_inn'])) {
			$data['payment_bifit_cashier_inn'] =
				$this->request->post['payment_bifit_cashier_inn'];
		} else {
			$data['payment_bifit_cashier_inn'] = $this->config->get(
				'payment_bifit_cashier_inn'
			);
		}

		// значение параметра "ФИО клиента"
		if (isset($this->request->post['payment_bifit_fio'])) {
			$data['payment_bifit_fio'] =
				$this->request->post['payment_bifit_fio'];
		} else {
			$data['payment_bifit_fio'] = $this->config->get(
				'payment_bifit_fio'
			);
		}

		// значение параметра "Место рассчётов"
		if (isset($this->request->post['payment_bifit_payment_address'])) {
			$data['payment_bifit_payment_address'] =
				$this->request->post['payment_bifit_payment_address'];
		} else {
			$data['payment_bifit_payment_address'] = $this->config->get(
				'payment_bifit_payment_address'
			);
		}

		// значение параметра "Адрес клиента"
		if (isset($this->request->post['payment_bifit_address_type'])) {
			$data['payment_bifit_address_type'] =
				$this->request->post['payment_bifit_address_type'];
		} else {
			$data['payment_bifit_address_type'] = $this->config->get(
				'payment_bifit_address_type'
			);
		}

		// значение параметра "Признак способа рассчёта"
		if (isset($this->request->post['payment_bifit_calculation_method'])) {
			$data['payment_bifit_calculation_method'] =
				$this->request->post['payment_bifit_calculation_method'];
		} else {
			$data['payment_bifit_calculation_method'] = $this->config->get(
				'payment_bifit_calculation_method'
			);
		}

		// значение параметра "Тип оплаты"
		if (isset($this->request->post['payment_bifit_payment_type'])) {
			$data['payment_bifit_payment_type'] =
				$this->request->post['payment_bifit_payment_type'];
		} else {
			$data['payment_bifit_payment_type'] = $this->config->get(
				'payment_bifit_payment_type'
			);
		}

		// значение параметра "Единный НДС"
		if (isset($this->request->post['payment_bifit_vat_mode'])) {
			$data['payment_bifit_vat_mode'] =
				$this->request->post['payment_bifit_vat_mode'];
		} else {
			$data['payment_bifit_vat_mode'] = $this->config->get(
				'payment_bifit_vat_mode'
			);
		}

		// значение параметра "НДС"
		if (isset($this->request->post['payment_bifit_vat'])) {
			$data['payment_bifit_vat'] =
				$this->request->post['payment_bifit_vat'];
		} else {
			$data['payment_bifit_vat'] = $this->config->get(
				'payment_bifit_vat'
			);
		}

		// значение параметра "Статус"
		if (isset($this->request->post['payment_bifit_status'])) {
			$data['payment_bifit_status'] =
				$this->request->post['payment_bifit_status'];
		} else {
			$data['payment_bifit_status'] = $this->config->get(
				'payment_bifit_status'
			);
		}

		// значение параметра "Порядок сортировки"
		if (isset($this->request->post['payment_bifit_sort_order'])) {
			$data['payment_bifit_sort_order'] =
				$this->request->post['payment_bifit_sort_order'];
		} else {
			$data['payment_bifit_sort_order'] = $this->config->get(
				'payment_bifit_sort_order'
			);
		}		

		// перебираем 4-ре вкладки (типы документов)
		for ($i = 1; $i <= 4; $i++) {

			/// значение параметра "Использовать" для каждого типа документа (4 шт.)
			if (isset($this->request->post['payment_bifit_use_type_' . $i])) {
				$data['payment_bifit_use_type_' . $i] =
					$this->request->post['payment_bifit_use_type_' . $i];
			} else {
				$data['payment_bifit_use_type_' . $i] = $this->config->get(
					'payment_bifit_use_type_' . $i
				);
			}

			/// значение параметра "Система налогообложения" для каждого типа документа (4 шт.)
			if (isset($this->request->post['payment_bifit_tax_system_' . $i])) {
				$data['payment_bifit_tax_system_' . $i] =
					$this->request->post['payment_bifit_tax_system_' . $i];
			} else {
				$data['payment_bifit_tax_system_' . $i] = $this->config->get(
					'payment_bifit_tax_system_' . $i
				);
			}

			/// значение параметра "Статус заказа" для каждого типа документа (4 шт.)
			if (isset($this->request->post['payment_bifit_order_status_id_' . $i])) {
				$data['payment_bifit_order_status_id_' . $i] =
					$this->request->post['payment_bifit_order_status_id_' . $i];
			} else {
				$data['payment_bifit_order_status_id_' . $i] = $this->config->get(
					'payment_bifit_order_status_id_' . $i
				);
			}

			/// значение параметра "Способ оплаты для каждого типа документа (4 шт.)
			if (isset($this->request->post['payment_bifit_payment_method_' . $i])) {
				$data['payment_bifit_payment_method_' . $i] =
					$this->request->post['payment_bifit_payment_method_' . $i];
			} else {
				$data['payment_bifit_payment_method_' . $i] = $this->config->get(
					'payment_bifit_payment_method_' . $i
				);
			}
		}

		$this->load->model('localisation/order_status');
		$data[
			'order_statuses'
		] = $this->model_localisation_order_status->getOrderStatuses();
		$this->load->model('setting/extension');
		$extensions = $this->model_setting_extension->getInstalled('payment');
		foreach ($extensions as $key => $value) {
			if (
				!is_file(
					DIR_APPLICATION .
						'controller/extension/payment/' .
						$value .
						'.php'
				) &&
				!is_file(
					DIR_APPLICATION . 'controller/payment/' . $value . '.php'
				)
			) {
				$this->model_setting_extension->uninstall('payment', $value);
				unset($extensions[$key]);
			}
		}
		$p_metods = array();
		// Compatibility code for old extension folders
		$files = glob(DIR_APPLICATION . 'controller/extension/payment/*.php');
		if ($files) {
			foreach ($files as $file) {
				$extension = basename($file, '.php');
				if ($extension == 'bifit') {
					continue;
				}
				$this->load->language(
					'extension/payment/' . $extension,
					'extension'
				);
				$status = $this->config->get(
					'payment_' . $extension . '_status'
				)
					? 1
					: 0;
				if ($status) {
					$p_metods[] = array(
						'name' => $this->language
							->get('extension')
							->get('heading_title'),
						'code' => $extension
					);
				}
			}
		}
		$data['payment_methods'] = $p_metods;

		if (isset($this->request->post['payment_bifit_geo_zone_id'])) {
			$data['payment_bifit_geo_zone_id'] =
				$this->request->post['payment_bifit_geo_zone_id'];
		} else {
			$data['payment_bifit_geo_zone_id'] = $this->config->get(
				'payment_bifit_geo_zone_id'
			);
		}
		$this->load->model('localisation/geo_zone');
		$data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();		

		// ПАРАМЕТРЫ СОРТИРОВКИ ОТЧЁТОВ
		/// параметр "sort"
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'bt.order_id';
		}
		/// параметр "order"
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}
		/// параметр "page"
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		// ОТЧЁТЫ

		// основные параметры
		$data['reports'] = array();
		$filter_data = array(
			'sort' => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' => $this->config->get('config_limit_admin')
		);
		$this->load->model('extension/payment/bifit');
		$report_total = $this->model_extension_payment_bifit->getTotalTransactions(
			$filter_data
		);
		$results = $this->model_extension_payment_bifit->getTransactions(
			$filter_data
		);

		// параметры каждой транзакции
		foreach ($results as $result) {
			$receipt_link = $result['receipt_link'];
			$order_number = 
				$result['order_number'] != '' && $result['order_number'] != '0' 
				? $result['order_number'] : $result['order_id'];
			$data['reports'][] = array(
				'id' => $result['bifit_transaction_id'],
				'order_id' => $result['order_id'],
				'order_number' => $order_number,
				'order_date' => $result['order_date'],
				'action_date' => $result['action_date'],
				'receipt_link' => $receipt_link,
				'receipt_id' => (int) $result['receipt_id'],
				'log' => nl2br($result['log']),
				'receipt_type' => $result['receipt_type'],
				'remove' => $this->url->link(
					'extension/payment/bifit/deletetransaction',
					'user_token=' .
						$this->session->data['user_token'] .
						'&id=' .
						(int) $result['bifit_transaction_id'],
					true
				),
				'orderlink' => $this->url->link(
					'sale/order/info',
					'user_token=' .
						$this->session->data['user_token'] .
						'&order_id=' .
						(int) $result['order_id'],
					true
				)
			);
		}

		// выделенная строка
		if (isset($this->request->post['selected'])) {
			$data['selected'] = (array) $this->request->post['selected'];
		} else {
			$data['selected'] = array();
		}

		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		// Пагинация
		$pagination = new Pagination();
		$pagination->total = $report_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link(
			'extension/payment/bifit',
			'user_token=' .
				$this->session->data['user_token'] .
				$url .
				'&page={page}#reportstab',
			true
		);
		$data['pagination'] = $pagination->render();
		$data['results'] = sprintf(
			$this->language->get('text_pagination'),
			$report_total
				? ($page - 1) * $this->config->get('config_limit_admin') + 1
				: 0,
			($page - 1) * $this->config->get('config_limit_admin') >
			$report_total - $this->config->get('config_limit_admin')
				? $report_total
				: ($page - 1) * $this->config->get('config_limit_admin') +
					$this->config->get('config_limit_admin'),
			$report_total,
			ceil($report_total / $this->config->get('config_limit_admin'))
		);
		$data['user_token'] = $this->session->data['user_token'];

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];
			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');
		$this->response->setOutput(
			$this->load->view('extension/payment/bifit', $data)
		);
	}

	public function install()
	{
		if ($this->user->hasPermission('modify', 'marketplace/extension')) {
			$this->load->model('extension/payment/bifit');
			$this->model_extension_payment_bifit->install();
		}
	}

	public function uninstall()
	{
		if ($this->user->hasPermission('modify', 'marketplace/extension')) {
			$this->load->model('extension/payment/bifit');
			$this->model_extension_payment_bifit->uninstall();
		}
	}

	public function deletetransaction()
	{
		if (isset($this->request->get['id'])) {
			$id = (int) $this->request->get['id'];
		} else {
			$id = 0;
		}

		$this->load->model('extension/payment/bifit');
		$this->model_extension_payment_bifit->delete($id);
		$this->response->redirect(
			$this->url->link(
				'extension/payment/bifit',
				'user_token=' . $this->session->data['user_token'],
				true
			)
		);
	}

	protected function validate()
	{
		if (!$this->user->hasPermission('modify', 'extension/payment/bifit')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (!$this->request->post['payment_bifit_token']) {
			$this->error['token'] = $this->language->get('error_token');
		}

		return !$this->error;
	}
}