<?php
class ModelExtensionPaymentBifit extends Model
{
	function getExtensions($type)
	{
		$query = $this->db->query(
			"SELECT * FROM " .
				DB_PREFIX .
				"extension WHERE `type` = '" .
				$this->db->escape($type) .
				"'"
		);

		return $query->rows;
	}

	public function getOrder($order_id)
	{
		$query = $this->db->query(
			"SELECT * FROM " .
				DB_PREFIX .
				"order WHERE `order_id` = '" .
				$order_id .
				"'"
		);

		return $query->row;
	}

	public function getTransactions($data = array())
	{
		$sql = "SELECT * FROM `" . DB_PREFIX . "bifit_transaction`";
		$sql .= " ORDER BY `bifit_transaction_id`";
		$sql .= " DESC";

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .=
				" LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
		}

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getTotalTransactions($data = array())
	{
		$sql =
			"SELECT COUNT(*) AS `total` FROM `" .
			DB_PREFIX .
			"bifit_transaction`  WHERE 1 = 1";
		$implode = array();

		if ($implode) {
			$sql .= " AND " . implode(" AND ", $implode);
		}

		$query = $this->db->query($sql);

		return $query->row['total'];
	}

	public function install()
	{
		$this->load->model('setting/event');
		$this->model_setting_event->addEvent(
			'bifit_send',
			'catalog/model/checkout/order/addOrderHistory/before',
			'extension/payment/bifit/bifitSend'
		);
		$this->db->query(
			"CREATE TABLE IF NOT EXISTS `" .
				DB_PREFIX .
				"bifit_transaction` (
					`bifit_transaction_id` int(11) NOT NULL AUTO_INCREMENT,
					`order_id` int(11) NOT NULL DEFAULT '0',
					`order_number` varchar(50) NOT NULL,
					`order_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
					`action_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
					`receipt_link` varchar(255) NOT NULL,
					`receipt_id` int(11) NOT NULL DEFAULT '0',
					`receipt_type` varchar(50) NOT NULL,
					`log` text NOT NULL,
					PRIMARY KEY (`bifit_transaction_id`)
				) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci"
		);

		return true;
	}

	public function uninstall()
	{
		$this->load->model('setting/event');
		$this->model_setting_event->deleteEventByCode('bifit_send');
		$this->db->query(
			"DROP TABLE IF EXISTS `" . DB_PREFIX . "bifit_transaction`"
		);

		return true;
	}

	public function delete($id)
	{
		$this->db->query(
			"DELETE FROM " .
				DB_PREFIX .
				"bifit_transaction WHERE `bifit_transaction_id` = '" .
				(int) $id .
				"'"
		);

		return true;
	}
}