<?php
class ModelExtensionPaymentBifit extends Model
{
	public function getMethod($address, $total)
	{
		return array();
	}

	public static function __createGUID($order)
	{
		// Create GUID (Globally Unique Identifier)
		$guid = '';
		$namespace = rand(11111, 99999);
		$uid = uniqid('', true);
		$data = $namespace;
		$data .= $_SERVER['REQUEST_TIME'];
		$data .= $_SERVER['HTTP_USER_AGENT'];
		$data .= $_SERVER['REMOTE_ADDR'];
		$data .= $_SERVER['REMOTE_PORT'];
		$data .= $order['number'];
		$data .= $order['summ'];
		$hash = strtoupper(hash('ripemd128', $uid . $guid . md5($data)));
		$guid =
			substr($hash, 0, 8) .
			'-' .
			substr($hash, 8, 4) .
			'-' .
			substr($hash, 12, 4) .
			'-' .
			substr($hash, 16, 4) .
			'-' .
			substr($hash, 20, 12);

		return strtolower($order['cms'] . '-' . $guid);
	}

	function __formatprc($price)
	{
		// конфигурация магазина
		$this->load->model('localisation/currency');
		$shop_currency = $this->config->get('config_currency');
		$decimal_place = $this->currency->getDecimalPlace($shop_currency);

		// форматируем цену согласно настроек
		$price =
			$decimal_place < 0
				? round($price, $decimal_place)
				: number_format($price, $decimal_place, '.', '');

		return $price;
	}

	function __checkInn($inn, $type = 1)
	{
		// проверяем заполненность
		if (isset($inn) && trim($inn) != '') {
			if ($type == 2) {
				// только цифры в количестве 10 шт.
				$inn = !preg_match("/^\d{10}$/", trim($inn))
					? "ИНН задан в неверном формате!"
					: trim($inn);
			} elseif ($type == 1) {
				// только цифры в количестве 12 шт.
				$inn = !preg_match("/^\d{12}$/", trim($inn))
					? "ИНН задан в неверном формате!"
					: trim($inn);
			} else {
				// только цифры в количестве 10 или 12 шт.
				$inn = !preg_match("/^\d{10}$|^\d{12}$/", trim($inn))
					? "ИНН задан в неверном формате!"
					: trim($inn);
			}
		} else {
			// ИНН пуст или не найден!
			$inn = "ИНН пуст или не найден!";
		}

		return $inn;
	}

	function __checkPhone($tel)
	{
		// проверяем заполненность
		if (isset($tel) && trim($tel) != '') {
			// удаляем лишние символы
			$phone = str_replace(
				array('+', '(', ')', '-', ' '),
				'',
				trim($tel)
			);

			// получаем первую цифру
			$first = substr($phone, "0", 1);

			// если номер из 10 цифр и первая цифра не 7, то добавляем 7
			$phone =
				strlen($phone) == 10 && $first != 7 ? '7' . $phone : $phone;

			// окончательная проверка
			$phone = !preg_match("/^[0-9]{11}+$/", $phone)
				? "Телефон задан в неверном формате!"
				: $phone;
		} else {
			// Телефон пуст или не найден!
			$phone = "Телефон пуст или не найден!";
		}

		return $phone;
	}

	function __checkEmail($email)
	{
		// проверка модели записи
		$email = !preg_match("/^\+\d+$|^\S+@\S+$/", $email)
			? "E-mail задан в неверном формате!"
			: $email;

		return $email;
	}

	function __checkProductPrice(
		$item_price,
		$order_subtotal,
		$order_discount = 0
	) {
		// если скидка больше нуля
		if ($order_discount > 0) {
			// вычисляем процент скидки
			$percent = ($order_discount * 100) / $order_subtotal;

			// уменьшаем цену товара согласно скидки
			$item_price = $item_price - $item_price * ($percent / 100);
		}

		return $item_price;
	}

	function __checkResponce($response)
	{
		$mess = '';

		if (
			is_object($response) &&
			(
				(isset($response->type) && $response->type == 'ERROR') || 
				(isset($response->status) && $response->status == 400)
			)
		) {
			$mess = '';

			if ($response->status == 400) {
				$mess .= $response->error . "\n";
				$mess .= $response->message . "\n";
			} else {
				$array = json_decode(json_encode($response), true);
				array_walk_recursive($array, function ($item, $key) use (
					&$mess
				) {
					if ($item != 'ERROR' && trim($item != '')) {
						$mess .= $key . ': ' . $item . "\n";
					}
				});
			}
		} elseif (is_object($response)) {
			$array = json_decode(json_encode($response), true);
			array_walk_recursive($array, function ($item, $key) use (&$mess) {

				if (trim($item != '')) {
					$mess .= $key . ': ' . $item . "\n";
				}
			});
		}

		return $mess;
	}

	function __loadData($url, $headers = false, $data = false, $type = 'POST')
	{
		// инициализируем сеанс cURL
		$ch = curl_init($url);

		// назначаем тип запроса
		if ($type != 'POST') {
			curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $type);
		} else {
			curl_setopt($ch, CURLOPT_POST, true);
		}

		// добавляем данные
		if ($data) {
			curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
		}

		// возврат результата в качестве строки
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_ENCODING, '');
		curl_setopt($ch, CURLOPT_MAXREDIRS, 10);
		curl_setopt($ch, CURLOPT_TIMEOUT, 0);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);

		// добавляем headers
		if ($headers) {
			curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		}

		// получаем ответ
		$output = curl_exec($ch);

		// завершаем сеанс cURL
		curl_close($ch);

		return $output;
	}

	function __saveReport($test, $bifit, $receipt, $receipt_id, $doc, $object, $idemp_key)
	{
		// выводим свойство операции
		$log =
			$test != ''
				? '####### ' . 'Тестовый запрос' . "\n"
				: '####### ' . 'Боевой запрос' . "\n";

		// выводим версию плагина
		$log .= '####### ' . 'Версия' . ' 1.2.7' . "\n";
		// выводим текущее время
		$log .= '####### ' . date('Y-m-d H:i:s', time()) . "\n";

		// ОТВЕТ #1

		$log .= '####### ' . 'Ответ' . ' #1: ' . "\n";

		// данные ответа #1
		$token_error = null;

		if (is_object($bifit)) {
			foreach ($bifit as $key => $val) {
				if ($key == 'error') {
					$token_error = 1;
				}
				$log .= $key . ': ' . $val . "\n";
			}
		}

		// ЧЕК

		// сформированный чек для отправки
		$log .= '####### ' . 'Чек' . ': ' . "\n" . $receipt . "\n";

		if (!$token_error) {
			// КЛЮЧ ИДЕМПОТЕНТНОСТИ

			$log .=
				'####### ' .
				'Ключ идемпотентности' .
				': ' .
				"\n" .
				$idemp_key .
				"\n";

			// ОТВЕТ #2

			$log .= '####### ' . 'Ответ' . ' #2: ' . "\n";

			// данные ответа #2
			if (is_object($receipt_id)) {
				$log .= self::__checkResponce($receipt_id);
			} else {
				$log .= 'Номер документа: ' . $receipt_id . "\n";

				// ОТВЕТ #3

				$log .= '####### ' . 'Ответ' . ' #3: ' . "\n";

				if (is_object($doc)) {
					$log .= self::__checkResponce($doc);
				}

				// ССЫЛКА НА ЧЕК

				// сформированная ссылка на чек
				$log .=
					'####### ' .
					'Ссылка на чек' .
					': ' .
					"\n" .
					$object->receipt_link;
			}
		}

		$object->log = $log;

		// СОХРАНЯЕМ В БД
		$this->db->query(
			"INSERT INTO `" .
				DB_PREFIX .
				"bifit_transaction` SET 
		`order_id` = '" .
				(int) $object->order_id .
				"',
		`order_number` = '" .
				(int) $object->order_number .
				"',
		`order_date` = '" .
				$object->order_date .
				"',
		`action_date` = '" .
				$object->action_date .
				"',
		`receipt_link` = '" .
				$object->receipt_link .
				"',
		`receipt_id` = '" .
				$object->receipt_id .
				"',  
		`receipt_type` = '" .
				$object->receipt_type .
				"', 
		`log` = '" .
				$object->log .
				"'"
		);
	}

	function __mainProcess($order, $test, $token, $i)
	{
		// 1. АВТОРИЗАЦИЯ
		//    процесс необходимый для подключения клиента к фискальному процессингу

		// адрес для POST-запроса
		$url = 'https://fp' . $test . '.bifit.com/processing-api/oauth/token';

		// данные ссылки
		$data = 'token=' . $token;
		$data .= '&client_id=processing-connector-token';
		$data .= '&client_secret=processing-connector-token';
		$data .= '&grant_type=token';

		// headers
		$headers = array('Content-Type: application/x-www-form-urlencoded');

		// декодируем полученный json-ответ
		$bifit = json_decode(self::__loadData($url, $headers, $data));

		// 2. ФОРМИРОВАНИЕ КОНТЕНТА ЧЕКА
		//    формирование информации для дальнейшей отправки на фискализацию

		// параметры плагина
		/// имя кассира
		$cashier_name = $this->config->get('payment_bifit_cashier_name');
		/// ИНН кассира
		$cashier_inn = $this->config->get('payment_bifit_cashier_inn');
		/// тип документа
		$arr_rec_type = array(
			'1' => 'SALE',
			'2' => 'SALE_RETURN',
			'3' => 'PURCHASE',
			'4' => 'PURCHASE_RETURN'
		);
		$receipt_type = $arr_rec_type[$i];
		/// система налогов
		$tax_system = $this->config->get(
			'payment_bifit_tax_system_' . $i,
			'SIMPLIFIED_WITH_EXPENSE'
		);
		/// признак способа расчёта
		$calc_method = $this->config->get('payment_bifit_calculation_method');
		/// единый НДС
		$vat_mode = $this->config->get('payment_bifit_vat_mode');
		/// НДС
		$vat = $this->config->get('payment_bifit_vat');
		/// тип оплаты
		$payment_type = $this->config->get('payment_bifit_payment_type');
		/// место расчётов
		$payment_address = $this->config->get('payment_bifit_payment_address');
		/// тип адреса клиента
		$address_type = $this->config->get('payment_bifit_address_type');
		/// ФИО клиента
		$fio = $this->config->get('payment_bifit_fio');
		/// адрес клиента в чеке (телефон или эл.почта)
		if ($address_type && $order["telephone"]) {
			$address = self::__checkPhone($order["telephone"]);
		} else {
			$address = $order["email"];
		}

		// позиции заказа
		/// получаем итоговые значения заказа
		$order_totals = $this->model_checkout_order->getOrderTotals(
			$order["order_id"]
		);
		/// параметр стоимости доставки
		$o_shipment = 0;
		/// параметр промежуточного итога заказа
		$sub_total = 0;
		/// параметр суммы купона
		$o_coupon = 0;

		// перебираем итоговые значения заказа
		foreach ($order_totals as $order_total) {
			/// стоимости доставки
			if ($order_total["code"] == 'shipping') {
				$o_shipment = (float) $order_total["value"];
			}
			/// промежуточной итог заказа
			if ($order_total["code"] == 'sub_total') {
				$sub_total = (float) $order_total["value"];
			}
			/// сумма купона
			if ($order_total["code"] == 'coupon') {
				$o_coupon = (float) $order_total["value"];
			}
		}

		// параметры массива
		/// формируемый параметр промежуточного итога
		$o_subtotal = 0;
		/// формируемый массив товаров
		$r_products = array();
		/// массив товаров заказа
		$products = $this->model_checkout_order->getOrderProducts(
			$order["order_id"]
		);

		// перебираем массив товаров заказа
		foreach ($products as $key_id => $product) {
			/// корректируем цену товара с учётом скидок
			$p_price = self::__formatprc(
				self::__checkProductPrice(
					$product["price"],
					$sub_total,
					$o_coupon
				)
			);
			/// формируем промежуточный итог
			$o_subtotal += $p_price * $product["quantity"];

			/// очищаем имя товара от спец-символов
			$p_name = preg_replace(
				'/[^\p{L}0-9\.,:;&*!\/|%[]()-]/iu',
				' ',
				html_entity_decode($product["name"])
			);
			$p_name = preg_replace('/ +/', ' ', trim($p_name));

			// формируем массив товаров для чека
			$r_products[$key_id]['name'] = $p_name;
			$r_products[$key_id]['price'] = $p_price;
			$r_products[$key_id]['quantity'] = $product["quantity"];
			$r_products[$key_id]['tax'] = $product["tax"];
		}

		// сверка итоговых сумм заказа и чека
		$total_1 = self::__formatprc($o_subtotal + $o_shipment);
		$total_2 = self::__formatprc($order["total"]);
		$diff =
			$total_1 > 0 && $total_2 > 0 && $total_1 != $total_2
				? abs($total_1 - $total_2)
				: 0;

		// параметры для чека
		$items = '';

		// формируем данные чека
		foreach ($r_products as $key_id => $product) {
			/// цена товара
			$p_price = $product["price"];

			/// корректировка цены товара согласно сверки
			if ($diff > 0 && $p_price > $diff) {
				$p_price =
					$total_2 > $total_1
						? $p_price + $diff / $product["quantity"]
						: $p_price - $diff / $product["quantity"];
				$diff = 0;
			}

			/// выводим данные товара в чек
			$items .= $items != '' ? ', ' : '';
			$items .= '{';
			$items .= '"calculationMethod":"' . $calc_method . '", ';
			$items .= '"paymentSubject":"PRODUCT", ';
			$items .= '"name":"' . $product["name"] . '", ';
			$items .= '"price":' . self::__formatprc($p_price) . ', ';
			$items .= '"quantity":' . $product["quantity"] . ', ';
			$items .=
				$vat_mode == 1
					? '"vat":"' . $vat . '", '
					: '"vat":"VAT_' . floor($product["tax"]) . '", ';
			$items .=
				'"total":' . self::__formatprc($p_price * $product["quantity"]);
			$items .= '}';
		}

		// доставка
		if ($o_shipment > 0) {
			// выводим данные способа доставки в чек
			$items .= $items != '' ? ', ' : '';
			$items .= '{';
			$items .= '"calculationMethod":"' . $calc_method . '", ';
			$items .= '"paymentSubject":"SERVICE", ';
			$items .= '"name":"Доставка", ';
			$items .= '"price":' . self::__formatprc($o_shipment) . ', ';
			$items .= '"quantity":1, ';
			$items .= '"vat":"' . $vat . '", ';
			$items .= '"total":' . self::__formatprc($o_shipment);
			$items .= '}';
		}

		// формируем чек
		$receipt = '{';
		$receipt .=
			'"type":"' .
			$receipt_type .
			'", "taxSystem":"' .
			$tax_system .
			'", ';
		$receipt .= '"cashier":{';
		$receipt .= '"name":"' . $cashier_name . '", ';
		$receipt .= '"inn":"' . self::__checkInn($cashier_inn, 1) . '"';
		$receipt .= '}, ';
		$receipt .= '"client":{';
		$receipt .= $fio
			? '"name":"' .
				trim($order["lastname"] . ' ' . $order["firstname"]) .
				'", '
			: '';
		$receipt .= '"address":"' . $address . '"';
		$receipt .= '}, ';
		$receipt .= '"paymentAddress":"' . $payment_address . '", ';
		$receipt .= '"items":[' . $items . '], ';
		$receipt .= '"total":' . self::__formatprc($order["total"]) . ', ';
		$receipt .=
			'"payments":{"' .
			$payment_type .
			'": ' .
			self::__formatprc($order["total"]) .
			'}';
		$receipt .= '}';

		// 3. ОТПРАВКА ЧЕКА В ФИСКАЛЬНЫЙ ПРОЦЕССИНГ
		//    передача контента чека в фискальный процессинг для дальнейшей фискализации

		// адрес для POST-запроса
		$url =
			'https://fp' .
			$test .
			'.bifit.com/processing-api/protected/documents/registration/receipts';

		// данные чека
		$data = $receipt;

		// ключ идемпотентности (Idempotency-Key)
		$o = [];
		$o['number'] = $order["invoice_prefix"] . $order["invoice_no"];
		$o['summ'] = self::__formatprc($order["total"]);
		$o['cms'] = 'OpenCart';
		$idemp_key = self::__createGUID($o);

		// headers
		$headers = array(
			'Content-Type: application/json',
			'Authorization: Bearer ' . $bifit->access_token,
			'Idempotency-Key: ' . $idemp_key
		);

		// получаем идентификатор документа на процессинге (id)
		$receipt_id = json_decode(self::__loadData($url, $headers, $data));

		// 4. ПОЛУЧЕНИЕ ДОКУМЕНТА ПО ID
		//    получение документа с фискальными признаками по его номеру

		// параметры
		$doc = '';

		if (!is_object($receipt_id)) {
			// ссылка для GET-запроса
			$url =
				'https://fp' .
				$test .
				'.bifit.com/processing-api/protected/documents/' .
				$receipt_id;

			// headers
			$headers = array('Authorization: Bearer ' . $bifit->access_token);

			// получаем документ
			$doc = json_decode(self::__loadData($url, $headers, false, 'GET'));
		}

		// ССЫЛКА НА ЧЕК

		// формируем ссылку на чек
		$receipt_link = !is_object($receipt_id)
			? 'https://fp' .
				$test .
				'.bifit.com/processing-api/receipts/' .
				$idemp_key
			: 'XXX';

		// ИСТОРИЯ ОПЕРАЦИИ

		// параметры объекта
		$object = new stdClass();
		/// id заказа
		$object->order_id = $order["order_id"];
		/// номер заказа
		$object->order_number = $order["invoice_prefix"] . $order["invoice_no"];
		/// дата заказа
		$object->order_date = $order["date_added"];
		/// дата операции
		$object->action_date = date('Y-m-d H:i:s');
		/// ссылка на чек
		$object->receipt_link = $receipt_link;
		/// id полученного документа
		$object->receipt_id = !is_object($receipt_id) ? $receipt_id : '000';
		/// тип проводимого документа
		$object->receipt_type = $receipt_type;
		/// лог операции (будет заполнен далее)
		$object->log = '';

		// сохраняем операцию в историю
		self::__saveReport($test, $bifit, $receipt, $receipt_id, $doc, $object, $idemp_key);
	}

	public function onBeforeDisplayCheckoutFinish($order_data)
	{
		// получаем заказ
		$this->load->model('checkout/order');
		$order = $this->model_checkout_order->getOrder($order_data[0]);

		// данные заказа
		$status_id = (int) $order_data[1];
		$order["status_id"] = $status_id;
		$payment_id = $order["payment_code"];

		// параметры плагина
		/// выбранный режим работы
		$test = $this->config->get('payment_bifit_test') ? '-test' : '';
		/// токен для соединения
		$token =
			$test != ''
				? 'P5cKbUUD9uSSrSlGdzspLblvBnD0GzTAE0cLmAPSEMxJ79DtLE'
				: $this->config->get('payment_bifit_token');

		// перебираем вкладки типов документа
		for ($i = 1; $i <= 4; $i++) {
			/// узнаём нужно ли использовать данный тип документа
			$use_type = $this->config->get('payment_bifit_use_type_' . $i);
			/// если использовать нужно
			if ($use_type) {
				//// выбранный способ(ы) оплаты
				$pm_ids = (array) $this->config->get(
					'payment_bifit_payment_method_' . $i
				);
				//// выбранный статус(ы) заказа
				$pm_statuses = (array) $this->config->get(
					'payment_bifit_order_status_id_' . $i
				);
				//// если совпадает способ оплаты и статус заказа
				if (
					isset($pm_ids) &&
					isset($pm_statuses) &&
					in_array($payment_id, $pm_ids) &&
					in_array($status_id, $pm_statuses) &&
					$token != ''
				) {
					///// запускаем БИФИТ-процесс
					self::__mainProcess($order, $test, $token, $i);
				}
			}
		}
	}
}