<?php
/**
 * @version     5.0.1
 * @package     Virtuemart.Plugin
 * @subpackage  Vmpayment.bifit
 *
 * @copyright   Copyright (C) 2021—2026 BIFIT. All rights reserved.
 * @license     GNU General Public License version 2 or later
 */

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

\defined('_JEXEC') or die();

class JFormFieldPayments extends JFormField
{
	protected $type = 'payments';

	public function getInput()
	{
		if (
			!file_exists(JPATH_SITE . "/components/com_virtuemart/virtuemart.php")
		) {
			Factory::getApplication()->enqueueMessage(
				Text::_('PLG_VMPAYMENT_BIFIT_WARNING'),
				'error'
			);
		} else {
			require_once JPATH_ROOT .
				'/administrator/components/com_virtuemart/helpers/config.php';

			VmConfig::loadConfig();
			VmConfig::loadJLang('com_virtuemart', true);

			$model = VmModel::getModel('paymentmethod');
			$paymethods = $model->getPayments();
			$name = $this->name . '[]';
			$value = empty($this->value) ? '' : $this->value;
			$size = count($paymethods) > 1 ? count($paymethods) : 2;

			return HTMLHelper::_(
				'select.genericlist',
				$paymethods,
				$name,
				'class="form-select" id="paymethods" size="' . $size . '" multiple="multiple"',
				'virtuemart_paymentmethod_id',
				'payment_name',
				$value
			);
		}
	}
}
