<?php
/**
 * @version     5.0.1
 * @package     Virtuemart.Plugin
 * @subpackage  Vmpayment.bifit
 *
 * @copyright   Copyright (C) 2021—2026 BIFIT. All rights reserved.
 * @license     GNU General Public License version 2 or later
 */

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;

\defined('_JEXEC') or die();

class JFormFieldStatuses extends JFormField
{
	protected $type = 'statuses';

	public function getInput()
	{
		if (
			!file_exists(JPATH_SITE . "/components/com_virtuemart/virtuemart.php")
		) {
			Factory::getApplication()->enqueueMessage(
				Text::_('PLG_VMPAYMENT_BIFIT_WARNING'),
				'error'
			);
		} else {
			require_once JPATH_ROOT .
				'/administrator/components/com_virtuemart/helpers/config.php';

			VmConfig::loadConfig();
			VmConfig::loadJLang('com_virtuemart', true);

			$model = VmModel::getModel('orderstatus');
			$statuses = $model->getOrderStatusList(false);

			foreach ($statuses as $key => $os) {
				$statuses[$key]->order_status_name = vmText::_(
					$os->order_status_name
				);
			}

			$name = $this->name . '[]';
			$value = empty($this->value) ? '' : $this->value;
			$size = count($statuses) > 1 ? count($statuses) : 2;

			return HTMLHelper::_(
				'select.genericlist',
				$statuses,
				$name,
				'class="form-select" id="statuses" size="' . $size . '" multiple="multiple"',
				'order_status_code',
				'order_status_name',
				$value
			);
		}
	}
}
