<?php
/**
 * @version     5.0.1
 * @package     Virtuemart.Plugin
 * @subpackage  Vmpayment.bifit
 *
 * @copyright   Copyright (C) 2021—2026 BIFIT. All rights reserved.
 * @license     GNU General Public License version 2 or later
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\String\StringHelper;

\defined('_JEXEC') or die();

HTMLHelper::_('bootstrap.modal');

class JFormFieldTransactions extends JFormField
{
	protected $type = 'transactions';

	public function getLabel()
	{
		return null;
	}

	public function getInput()
	{
		if (
			!file_exists(JPATH_SITE . "/components/com_virtuemart/virtuemart.php")
		) {
			Factory::getApplication()->enqueueMessage(
				Text::_('PLG_VMPAYMENT_BIFIT_WARNING'),
				'error'
			);
		} else {
			// параметры
			$app = Factory::getApplication();
			$del = $app->input->getInt('del', null);
			$log = $app->input->getInt('log', null);

			$url = Uri::current() . '?';
			$url .= 'option=com_plugins&';
			$url .= 'view=plugin&';
			$url .= 'layout=edit&';
			$url .= 'extension_id=' . $app->input->getInt('extension_id');

			// удаление записи
			if ($del) {
				$db = Factory::getDbo();
				$db->setQuery(
					$db
						->getQuery(true)
						->delete(
							$db->quoteName(
								$db->getPrefix() . 'virtuemart_bifit_reports'
							)
						)
						->where($db->quoteName('id') . ' = ' . $del)
				);

				if ($db->execute()) {
					$app->enqueueMessage(
						Text::_('PLG_VMPAYMENT_BIFIT_DEL_SUCCESS'),
						'success'
					);
				} else {
					$app->enqueueMessage(
						Text::_('PLG_VMPAYMENT_BIFIT_DEL_ERROR_OCCURR'),
						'error'
					);
				}

				$app->redirect($url);
				exit();
			}

			// запрос в бд
			$db = Factory::getDbo();
			$db->setQuery(
				$db
					->getQuery(true)
					->select('*')
					->from(
						$db->quoteName(
							$db->getPrefix() . 'virtuemart_bifit_reports'
						)
					)
					->order($db->quoteName('id') . ' DESC')
			);
			$actions = $db->execute() ? $db->loadObjectList() : [];

			// пагинация
			$context = "virtuemart.list.admin.bifit_actions";
			$limit = $app->getUserStateFromRequest(
				$context . 'limit',
				'limit',
				$app->getCfg('list_limit'),
				'int'
			);
			$limitstart = $app->getUserStateFromRequest(
				$context . 'limitstart',
				'limitstart',
				0,
				'int'
			);
			$total = count($actions);
			$pagination = new \JPagination($total, $limitstart, $limit);
			$actions = array_slice(
				$actions,
				$pagination->limitstart,
				$pagination->limit
			);
			$d = "document.getElementById('style-form').id='adminForm';";
			$s = "document.adminForm.limitstart";
			$listFooter = StringHelper::str_ireplace(
				$s,
				$d . $s,
				$pagination->getListFooter()
			);
			$s = "Joomla.submitform();";
			$limitBox = StringHelper::str_ireplace(
				$s,
				$d . $s,
				$pagination->getLimitBox()
			);

			// стили css
			$styles = '<style type="text/css">';
			$styles .=
				'#attrib-report .control-group .control-label{display:none!important}.table th.text-center{text-align:center}#bifit a.order_number {text-decoration:none;border-bottom: 1px dashed} #bifit a.order_number:hover {text-decoration:none;border-bottom: 1px solid} #bifit a.remove {color:darkred}.form-horizontal #attrib-report .control-label{display:none}.form-horizontal #attrib-report .controls{margin-left:0}span.error{font-weight:700;letter-spacing:.1em;color:red}span.success{font-weight:700;letter-spacing:.1em;color:forestgreen}span.type{padding:4px 10px;border-radius:4px;color:white;background:green}span.type-error{opacity:.5}span.type.type-sale{background:forestgreen;color:white}span.type.type-sale_return{background:lightgreen;color:black}span.type.type-purchase{background:lightslategrey;color:white}span.type.type-purchase_return{background:lightslateblue;color:black}';
			$styles .=
				'.btn-check:checked+.btn,:not(.btn-check)+.btn:active,.btn:first-child:active,.btn.active,.btn.show{background-color:#47854B;border-color:#47854B}';
			$styles .= '</style>';

			$html = $styles;

			// транзакции
			if (count($actions)) {
				// таблица
				$html .= '<table id="bifit" class="table table-striped">';

				// заголовки
				$html .= '<thead>';
				$html .= '<tr>';
				$html .= '<th class="nowrap">#</th>';
				$html .=
					'<th class="nowrap">' .
					Text::_('PLG_VMPAYMENT_BIFIT_ORDER_ID') .
					'</th>';
				$html .=
					'<th class="nowrap">' .
					Text::_('PLG_VMPAYMENT_BIFIT_ORDER_NUMBER') .
					'</th>';
				$html .=
					'<th class="nowrap">' .
					Text::_('PLG_VMPAYMENT_BIFIT_ORDER_DATE') .
					'</th>';
				$html .=
					'<th class="nowrap">' .
					Text::_('PLG_VMPAYMENT_BIFIT_ACTION_DATE') .
					'</th>';
				$html .=
					'<th class="nowrap">' .
					Text::_('PLG_VMPAYMENT_BIFIT_RECEIPT') .
					'</th>';
				$html .=
					'<th class="nowrap">' .
					Text::_('PLG_VMPAYMENT_BIFIT_DOCUMENT') .
					'</th>';
				$html .=
					'<th class="nowrap">' .
					Text::_('PLG_VMPAYMENT_BIFIT_LOG') .
					'</th>';
				$html .=
					'<th class="nowrap">' .
					Text::_('PLG_VMPAYMENT_BIFIT_TYPE') .
					'</th>';
				$html .=
					'<th class="text-center">' .
					Text::_('PLG_VMPAYMENT_BIFIT_REMOVE') .
					'</th>';
				$html .= '</tr>';
				$html .= '</thead>';

				// центр
				$html .= '<tbody>';

				// список транзакций
				foreach ($actions as $key_id => $action) {
					$html .= '<tr>';

					// порядковый номер
					$html .= '<td>' . ($limitstart + $key_id + 1) . '</td>';
					// id заказа
					$html .=
						'<td><a target="_blank" class="btn btn-sm btn-default" href="' .
						Uri::current() .
						'?option=com_virtuemart&view=orders&task=edit&virtuemart_order_id=' .
						$action->order_id .
						'">&nbsp;№' .
						$action->order_id .
						'</a></td>';
					// номер заказа
					$html .=
						'<td><a target="_blank" class="order_number" href="' .
						Uri::current() .
						'?option=com_virtuemart&view=orders&task=edit&virtuemart_order_id=' .
						$action->order_id .
						'">&nbsp;№' .
						$action->order_number .
						'</a></td>';
					// дата заказа
					$html .=
						'<td class="nowrap"><span class="icon icon-calendar me-2"></span>' .
						$action->order_date .
						'</td>';
					// дата запроса
					$html .=
						'<td class="nowrap"><span class="icon icon-calendar me-2"></span>' .
						(isset($action->action_date)
							? $action->action_date
							: $action->order_date) .
						'</td>';
					// ссылка на чек
					$html .=
						'<td>' .
						((int) $action->receipt_id > 0
							? '<a target="_blank" href="' .
								$action->receipt_link .
								'" class="btn btn-sm btn-primary">&nbsp;' .
								Text::_('PLG_VMPAYMENT_BIFIT_OPEN') .
								'</a>'
							: '<span class="error">' .
								'<span class="icon icon-warning me-1"></span>' .
								Text::_('PLG_VMPAYMENT_BIFIT_NO') .
								'</span>') .
						'</td>';
					// документ
					$html .=
						'<td>' .
						'<span class="' .
						((int) $action->receipt_id > 0 ? 'success' : 'error') .
						'">' .
						'<span class="icon icon-' .
						((int) $action->receipt_id > 0 ? 'tag' : 'warning') .
						' me-1"></span>' .
						((int) $action->receipt_id > 0
							? (int) $action->receipt_id
							: Text::_('PLG_VMPAYMENT_BIFIT_NO')) .
						'</span>' .
						'</td>';
					// лог-файл
					$html .=
						'<td><button type="button" data-bs-toggle="modal" data-bs-target="#log' .
						$action->id .
						'" class="btn btn-sm btn-' .
						((int) $action->receipt_id > 0 ? 'success' : 'danger') .
						' mod"><span class="icon icon-file-alt me-1"></span>' .
						Text::_('PLG_VMPAYMENT_BIFIT_VIEW') .
						'</button><div class="modal fade" id="log' .
						$action->id .
						'" aria-hidden="true"><div class="modal-dialog modal-xl modal-dialog-scrollable"><div class="modal-content"><div class="modal-header"><h1 class="modal-title fs-5" id="staticBackdropLabel"><span class="icon-file-alt me-2"></span>' .
						Text::_('PLG_VMPAYMENT_BIFIT_LOG') .
						'</h1><button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button></div><div class="modal-body m-3"><code>' .
						StringHelper::str_ireplace("\n", "<br>", $action->log) .
						'</code></div></div></div></div></td>';
					// тип документа
					$html .=
						'<td class="nowrap">' .
						'<span class="type ' .
						((int) $action->receipt_id > 0
							? 'type-success'
							: 'type-error') .
						' type-' .
						StringHelper::strtolower($action->receipt_type) .
						'">' .
						Text::_(
							'PLG_VMPAYMENT_BIFIT_RECEIPT_TYPE_' .
								$action->receipt_type
						) .
						'</span>' .
						'</td>';
					// удалить
					$html .=
						'<td style="text-align:center;"><a href="' .
						$url .
						'&del=' .
						$action->id .
						'" class="remove"><span class="icon icon-trash"></span></a></td>';

					$html .= '</tr>';
				}

				$html .= '</tbody>';
				$html .= '</table>';

				// низ
				$html .=
					'<div class="d-flex justify-content-between align-items-center">';
				$html .= '<div class="vmart_list_footer">' . $listFooter . '</div>';
				$html .= '<div class="vmart_limit_box">' . $limitBox . '</div>';
				$html .= '</div>';
			} else {
				$html .=
					'<div class="alert alert-info"><strong>' .
					Text::_('PLG_VMPAYMENT_BIFIT_EMPTY_ACTIONS_LIST') .
					'</strong></div>';
			}

			return $html;
		}
	}
}
