<?php

final class Bifit_AdminSettings
{
	private static $options = [
		"test" => "integer",
		"token" => "string",
		"cashier_name" => "string",
		"cashier_inn" => "string",
		"pay_address" => "string",
		"address_type" => "string",
		"fio" => "integer",
		"calc_method" => "string",
		"payment_type" => "string",
		"product_vat" => "string",
		"shipping_vat" => "string",
		// added from the side (v.1.2.6)
		"tax_vat" => "string",
		// /added from the side (v.1.2.6)
		"use_type_1" => "integer",
		"use_type_2" => "integer",
		"use_type_3" => "integer",
		"use_type_4" => "integer",
		"tax_system_1" => "string",
		"tax_system_2" => "string",
		"tax_system_3" => "string",
		"tax_system_4" => "string",
		"woocommerce_status_1" => "array",
		"woocommerce_status_2" => "array",
		"woocommerce_status_3" => "array",
		"woocommerce_status_4" => "array",
		"woocommerce_payment_1" => "array",
		"woocommerce_payment_2" => "array",
		"woocommerce_payment_3" => "array",
		"woocommerce_payment_4" => "array",
	];

	public static function checklisthtml()
	{
		if (!empty($_POST)) {
			self::save();
		}

		include BIFIT_ABSPATH_VIEWS . "reports.php";
	}

	public static function mainsettings()
	{
		if (!empty($_POST)) {
			self::save();
		}

		include BIFIT_ABSPATH_VIEWS . "settings.php";
	}

	public static function save()
	{
		$parameters = self::$options;

		foreach ($parameters as $key => $type) {
			$value = filter_input(INPUT_POST, $key);
			$value = sanitize_text_field(strip_tags(stripslashes($value)));

			if ($value != null || $type == "array") {
				if ($type == "string") {
					update_option($key, $value);
				} elseif ($type == "bool") {
					update_option($key, $value === "1" ? "1" : "0");
				} elseif ($type == "integer") {
					update_option($key, intval($value));
				} elseif ($type == "array") {
					if (isset($_POST[$key]) && array_key_exists($key, $_POST)) {
						$new_arr = [];
						foreach ($_POST[$key] as $val) {
							$new_arr[] = sanitize_text_field(
								strip_tags(stripslashes($val))
							);
						}
						update_option($key, $new_arr);
					}
				}
			}
		}
	}
}
