<?php

final class Bifit_Admin
{
	public static function init()
	{
		add_action("admin_head", [__CLASS__, "menu_correction"]);
		add_action("admin_menu", [__CLASS__, "add_menu"]);
		add_action("admin_menu", [__CLASS__, "add_sub_menu"]);

		require_once BIFIT_ABSPATH . "lib/admin-settings.php";
	}

	public static function add_menu()
	{
		add_menu_page(
			"БИФИТ Касса",
			"БИФИТ Касса",
			"manage_options",
			"bifit",
			null,
			null,
			"55.6"
		);
	}

	public static function add_sub_menu()
	{
		global $submenu;

		add_submenu_page(
			"bifit",
			"Отчёт",
			"Отчёт",
			"manage_options",
			"bifit-reports",
			[__CLASS__, "bifit_reports"]
		);

		add_submenu_page(
			"bifit",
			"Настройки",
			"Настройки",
			"manage_options",
			"bifit-settings",
			[__CLASS__, "bifit_settings"]
		);
	}

	public static function menu_correction()
	{
		global $submenu;

		if (isset($submenu["bifit"])) {
			unset($submenu["bifit"][0]);
		}
	}

	public static function bifit_reports()
	{
		Bifit_AdminSettings::checklisthtml();
	}

	public static function bifit_settings()
	{
		Bifit_AdminSettings::mainsettings();
	}
}
