<?php

namespace Bifit\F;

class BifitFunctions
{
	static function dropdown_list($list, $value)
	{
		if (is_array($value)) {
			foreach ($list as $key => $item) {
				echo '<option value="' .
					$key .
					'"' .
					(in_array($key, $value) ? ' selected="selected"' : "") .
					">" .
					$item .
					"</option>";
			}
		} else {
			foreach ($list as $key => $item) {
				echo '<option value="' .
					$key .
					'"' .
					($key == $value ? ' selected="selected"' : "") .
					">" .
					$item .
					"</option>";
			}
		}
	}

	static function dropdown_yesno_list()
	{
		$list = [
			0 => "Нет",
			1 => "Да",
		];

		return $list;
	}

	static function dropdown_address_type_list()
	{
		$list = [
			"email" => "Email",
			"phone" => "Phone",
		];

		return $list;
	}

	static function dropdown_tax_system_list()
	{
		$list = [
			"COMMON" => "ОСН",
			"SIMPLIFIED" => "УСН доход",
			"SIMPLIFIED_WITH_EXPENSE" => "УСН доход-расход",
			"ENVD" => "ЕНВД",
			"COMMON_AGRICULTURAL" => "ЕСХН",
			"PATENT" => "ПАТЕНТ",
		];

		return $list;
	}

	static function dropdown_calc_method_list()
	{
		$list = [
			70 => "Брать признак способа расчёта из атрибута товара",
			"PREPAY_FULL" =>
				"Полная предварительная оплата до момента передачи предмета расчёта",
			"PREPAY_PARTIAL" =>
				"Частичная предварительная оплата до момента передачи предмета расчёта",
			"AVANS" => "Аванс",
			"FULL_PAY" =>
				"Полная оплата, в том числе с учётом аванса (предварительной оплаты) в момент передачи предмета расчёта",
			"PARTIAL_SETTLEMENT_AND_CREDIT" =>
				"Частичная оплата предмета расчёта в момент его передачи с последующей оплатой в кредит",
			"TRANSFER_ON_CREDIT" =>
				"Передача предмета расчёта без его оплаты в момент его передачи с последующей оплатой в кредит",
			"CREDIT_PAYMENT" =>
				"Оплата предмета расчёта после его передачи с оплатой в кредит (оплата кредита)",
		];

		return $list;
	}

	static function dropdown_payment_type_list()
	{
		$list = [
			"CASH" => "Сумма оплаты наличными",
			"CARD" => "Сумма оплата безналичными",
			"PREPAY" => "Сумма оплаты предоплатой (зачётом аванса)",
			"POSTPAY" => "Сумма оплаты постоплатой (в кредит)",
			"OTHER" => "Сумма оплаты встречным предоставлением",
		];

		return $list;
	}

	static function dropdown_product_vat_list()
	{
		$list = [
			70 => "Брать ставку НДС из атрибута товара",
			"WITHOUT_VAT" => "Без НДС",
			"VAT_0" => "НДС 0%",
			"VAT_5" => "НДС 5%",
			"VAT_7" => "НДС 7%",
			"VAT_10" => "НДС 10%",
			"VAT_20" => "НДС 20%",
			"VAT_22" => "НДС 22%",
			"VAT_105" => "НДС 5/105",
			"VAT_107" => "НДС 7/107",
			"VAT_110" => "НДС 10/110",
			"VAT_120" => "НДС 20/120",
			"VAT_122" => "НДС 22/122"
		];

		return $list;
	}

	static function dropdown_shipping_vat_list()
	{
		$list = [
			"WITHOUT_VAT" => "Без НДС",
			"VAT_0" => "НДС 0%",
			"VAT_5" => "НДС 5%",
			"VAT_7" => "НДС 7%",
			"VAT_10" => "НДС 10%",
			"VAT_20" => "НДС 20%",
			"VAT_22" => "НДС 22%",
			"VAT_105" => "НДС 5/105",
			"VAT_107" => "НДС 7/107",
			"VAT_110" => "НДС 10/110",
			"VAT_120" => "НДС 20/120",
			"VAT_122" => "НДС 22/122"
		];

		return $list;
	}

	// added from the side (v.1.2.6)
	static function dropdown_tax_vat_list()
	{
		$list = [
			"WITHOUT_VAT" => "Без НДС",
			"VAT_0" => "НДС 0%",
			"VAT_5" => "НДС 5%",
			"VAT_7" => "НДС 7%",
			"VAT_10" => "НДС 10%",
			"VAT_20" => "НДС 20%",
			"VAT_22" => "НДС 22%",
			"VAT_105" => "НДС 5/105",
			"VAT_107" => "НДС 7/107",
			"VAT_110" => "НДС 10/110",
			"VAT_120" => "НДС 20/120",
			"VAT_122" => "НДС 22/122"
		];

		return $list;
	}
	// /added from the side (v.1.2.6)
}
