<?php

final class setup_bifit
{
	public static function checkAttr($slug)
	{
		$attrList = wc_get_attribute_taxonomies();

		foreach ($attrList as $key => $attr) {
			if ($attr->attribute_name == $slug) {
				return true;
			}
		}

		return false;
	}

	public static function process_add_attribute($attribute)
	{
		global $wpdb;

		if (empty($attribute["attribute_type"])) {
			$attribute["attribute_type"] = "text";
		}

		if (empty($attribute["attribute_orderby"])) {
			$attribute["attribute_orderby"] = "menu_order";
		}

		if (empty($attribute["attribute_public"])) {
			$attribute["attribute_public"] = 0;
		}

		if (
			empty($attribute["attribute_name"]) ||
			empty($attribute["attribute_label"])
		) {
			return new WP_Error(
				"error",
				__("Please, provide an attribute name and slug.", "woocommerce")
			);
		} elseif (
			($valid_attribute_name = setup_bifit::valid_attribute_name(
				$attribute["attribute_name"]
			)) &&
			is_wp_error($valid_attribute_name)
		) {
			return $valid_attribute_name;
		} elseif (
			taxonomy_exists(
				wc_attribute_taxonomy_name($attribute["attribute_name"])
			)
		) {
			return new WP_Error(
				"error",
				sprintf(
					__(
						'Slug "%s" is already in use. Change it, please.',
						"woocommerce"
					),
					sanitize_title($attribute["attribute_name"])
				)
			);
		}

		$wpdb->insert(
			$wpdb->prefix . "woocommerce_attribute_taxonomies",
			$attribute
		);

		do_action("woocommerce_attribute_added", $wpdb->insert_id, $attribute);

		flush_rewrite_rules();

		delete_transient("wc_attribute_taxonomies");

		return true;
	}

	public static function activation()
	{
		if (!setup_bifit::checkAttr("stavka_nds")) {
			$insert = setup_bifit::process_add_attribute([
				"attribute_name" => "stavka_nds",
				"attribute_label" => "Ставка НДС",
				"attribute_type" => "text",
				"attribute_orderby" => "menu_order",
				"attribute_public" => false,
			]);

			if (is_wp_error($insert)) {
				do_something_for_error($insert);
			}
		}

		if (!setup_bifit::checkAttr("priznak_sposoba_rascheta")) {
			$insert = setup_bifit::process_add_attribute([
				"attribute_name" => "priznak_sposoba_rascheta",
				"attribute_label" => "Признак способа расчёта",
				"attribute_type" => "text",
				"attribute_orderby" => "menu_order",
				"attribute_public" => false,
			]);

			if (is_wp_error($insert)) {
				do_something_for_error($insert);
			}
		}

		global $wpdb;
		require_once ABSPATH . "wp-admin/includes/upgrade.php";

		$table_name = $wpdb->prefix . "bifit_reports";
		$charset_collate = $wpdb->get_charset_collate();
		$sql = "CREATE TABLE {$table_name} ( 
			`id` int(11) NOT NULL AUTO_INCREMENT, 
			`order_id` int(11) NOT NULL, 
			`order_number` varchar(255) NOT NULL, 
			`order_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP, 
			`action_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00', 
			`receipt_link` varchar(255) NOT NULL, 
			`receipt_id` int(11) NOT NULL, 
			`receipt_type` varchar(50) NOT NULL,
			`log` text NOT NULL, 
			PRIMARY KEY (id)
		) $charset_collate;";
		
		dbDelta($sql);

		$arr_terms1 = [
			[
				"a0" => "Без НДС",
				"a1" => "WITHOUT_VAT",
				"a2" => 255
			],
			[
				"a0" => "НДС 0%",
				"a1" => "VAT_0",
				"a2" => 255
			],
			[
				"a0" => "НДС 5%",
				"a1" => "VAT_5",
				"a2" => 255
			],
			[
				"a0" => "НДС 7%",
				"a1" => "VAT_7",
				"a2" => 255
			],
			[
				"a0" => "НДС 10%",
				"a1" => "VAT_10",
				"a2" => 255
			],
			[
				"a0" => "НДС 20%",
				"a1" => "VAT_20",
				"a2" => 255
			],
			[
				"a0" => "НДС 22%",
				"a1" => "VAT_22",
				"a2" => 255
			],
			[
				"a0" => "НДС 5/105",
				"a1" => "VAT_105",
				"a2" => 255
			],
			[
				"a0" => "НДС 7/107",
				"a1" => "VAT_107",
				"a2" => 255
			],
			[
				"a0" => "НДС 10/110",
				"a1" => "VAT_110",
				"a2" => 255
			],
			[
				"a0" => "НДС 20/120",
				"a1" => "VAT_120",
				"a2" => 255
			],
			[
				"a0" => "НДС 22/122",
				"a1" => "VAT_122",
				"a2" => 255
			],
		];

		$arr_terms2 = [
			[
				"a0" =>
					"Полная предварительная оплата до момента передачи предмета расчёта",
				"a1" => "PREPAY_FULL",
				"a2" => 256
			],
			[
				"a0" =>
					"Частичная предварительная оплата до момента передачи предмета расчёта",
				"a1" => "PREPAY_PARTIAL",
				"a2" => 256
			],
			[
				"a0" => "Аванс",
				"a1" => "AVANS",
				"a2" => 256
			],
			[
				"a0" =>
					"Полная оплата, в том числе с учётом аванса (предварительной оплаты) в момент передачи предмета расчёта",
				"a1" => "FULL_PAY",
				"a2" => 256
			],
			[
				"a0" =>
					"Частичная оплата предмета расчёта в момент его передачи с последующей оплатой в кредит",
				"a1" => "PARTIAL_SETTLEMENT_AND_CREDIT",
				"a2" => 256
			],
			[
				"a0" =>
					"Передача предмета расчёта без его оплаты в момент его передачи с последующей оплатой в кредит",
				"a1" => "TRANSFER_ON_CREDIT",
				"a2" => 256
			],
			[
				"a0" =>
					"Оплата предмета расчёта после его передачи с оплатой в кредит (оплата кредита)",
				"a1" => "CREDIT_PAYMENT",
				"a2" => 256
			],
		];

		$arr_mall = [
			"pa_stavka_nds" => $arr_terms1,
			"pa_priznak_sposoba_rascheta" => $arr_terms2
		];

		$table_name_terms = $wpdb->prefix . "terms";
		$table_name_term_taxonomy = $wpdb->prefix . "term_taxonomy";

		foreach ($arr_mall as $k0 => $v0) {
			$stt = $k0;
			foreach ($v0 as $k1 => $v1) {
				$aa0 = $v1["a0"];
				$aa1 = $v1["a1"];
				$aa2 = $v1["a2"];

				$sql_term0 = $wpdb->get_var(
					"SELECT COUNT(*) FROM `$table_name_terms` WHERE `slug` = '$aa1' AND `term_group` = '$aa2';"
				);

				if ($sql_term0 > 0) {
				} else {
					$sql_term1 = $wpdb->insert(
						$table_name_terms,
						[
							"name" => $aa0,
							"slug" => $aa1,
							"term_group" => $aa2,
						],
						["%s", "%s", "%d"]
					);
				}

				$sql_term2 = $wpdb->get_var(
					"SELECT `term_id` FROM `$table_name_terms` WHERE `slug` = '$aa1' AND `term_group` = '$aa2' LIMIT 1;"
				);
				$tmm2 = intval($sql_term2);

				if ($tmm2 > 0) {
					// NEW (v.1.2.7)
					// check for the presence of a record in the database
					$qnew1 = $wpdb->get_var(
						"SELECT `term_taxonomy_id` FROM `$table_name_term_taxonomy` WHERE `term_id` = '$tmm2' AND `taxonomy` = '$stt' AND `description` = 'sss' LIMIT 1;"
					);
					$anew1 = intval($qnew1);					

					if ($anew1 > 0) {
					} else {
					// /new (v.1.2.7)
						$sql_term3 = $wpdb->insert(
							$table_name_term_taxonomy,
							[
								"term_id" => $tmm2,
								"taxonomy" => $stt,
								"description" => "sss",
							],
							["%s", "%s", "%s"]
						);
					// NEW (v.1.2.7)
					// check for the presence of a record in the database
					}
					// /new (v.1.2.7)
				}
			}
		}
	}

	public static function deactivation()
	{
		global $wpdb;

		$table_name = $wpdb->prefix . "bifit_reports";
		$sql = "DROP TABLE IF EXISTS `$table_name`";
		$wpdb->query($sql);
	}

	public static function valid_attribute_name($attribute_name)
	{
		if (strlen($attribute_name) >= 28) {
			return new WP_Error(
				"error",
				sprintf(
					__(
						'Slug "%s" is too long (28 characters max). Shorten it, please.',
						"woocommerce"
					),
					sanitize_title($attribute_name)
				)
			);
		} elseif (wc_check_if_attribute_name_is_reserved($attribute_name)) {
			return new WP_Error(
				"error",
				sprintf(
					__(
						'Slug "%s" is not allowed because it is a reserved term. Change it, please.',
						"woocommerce"
					),
					sanitize_title($attribute_name)
				)
			);
		}

		return true;
	}
}
