<?php

if (!defined('ABSPATH')) {
	exit();
}

global $wpdb;

if (!current_user_can('manage_options')) {
	wp_die(
		__('You do not have sufficient permissions to access this page.')
	);
}

$paged = isset($_GET['paged']) ? intval($_GET['paged']) : 1;
$perpage = 25;
$from = ($paged - 1) * $perpage;
$table_name = $wpdb->prefix . 'bifit_reports';
$transactions = $wpdb->get_results(
	"SELECT * FROM `$table_name` ORDER BY `id` DESC LIMIT $from, $perpage;"
);
$count = $wpdb->get_var("SELECT COUNT(*) FROM `$table_name` WHERE 1 = 1;");
$total_items = $count;
$total_pages = ceil($total_items / $perpage);
$infinite_scroll = false;
$http = isset($_SERVER['HTTPS']) ? 'https://' : 'http://';
$current_url = set_url_scheme(
	$http . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']
);
$del = isset($_GET['del']) ? intval($_GET['del']) : null;

session_start();

if ($del) {
	$wpdb->delete($table_name, array('id' => $del), array('%d'));
	$link = str_replace('&del=' . $del, '', $current_url);
	$_SESSION['bifit_del_message'] = 'Запись успешно удалена!';
	wp_redirect($link);
	exit();
}
?>
<div class="wrap">
	<h1><span style="color:#000000;font-weight:700;">БИФИТ <span style="color:#67AEF7;">Касса</span></span></h1>
	<?php
	if (!empty($_SESSION['bifit_del_message'])) {
		echo '<div id="setting-error-settings_updated" class="notice notice-success settings-error is-dismissible">';
		echo '<p><strong>' . $_SESSION['bifit_del_message'] . '</strong></p>';
		echo '</div>';
		unset($_SESSION['bifit_del_message']);
	}
	?>
	<hr>
	<?php
	if (!$count) {
		echo '<div class="notice notice-error"><p>Список транзакций пуст!</p></div>';
		echo '</div>';

		return;
	} else {
		echo '<div>Список сохранённых транзакций</div>';
	}

	$output =
		'<span class="displaying-num">' .
		sprintf(
			_n('%s item', '%s items', $total_items),
			number_format_i18n($total_items)
		) .
		'</span>';

	$current = $paged;
	$removable_query_args = wp_removable_query_args();
	$current_url = remove_query_arg($removable_query_args, $current_url);
	$page_links = array();
	$total_pages_before = '<span class="paging-input">';
	$total_pages_after = '</span></span>';
	$disable_first = false;
	$disable_last = false;
	$disable_prev = false;
	$disable_next = false;

	if ($current == 1) {
		$disable_first = true;
		$disable_prev = true;
	}

	if ($current == 2) {
		$disable_first = true;
	}

	if ($current == $total_pages) {
		$disable_last = true;
		$disable_next = true;
	}

	if ($current == $total_pages - 1) {
		$disable_last = true;
	}

	if ($disable_first) {
		$page_links[] =
			'<span class="tablenav-pages-navspan" aria-hidden="true">&laquo;</span>';
	} else {
		$page_links[] = sprintf(
			"<a class='first-page' href='%s'><span class='screen-reader-text'>%s</span><span aria-hidden='true'>%s</span></a>",
			esc_url(remove_query_arg('paged', $current_url)),
			__('First page'),
			'&laquo;'
		);
	}

	if ($disable_prev) {
		$page_links[] =
			'<span class="tablenav-pages-navspan" aria-hidden="true">&lsaquo;</span>';
	} else {
		$page_links[] = sprintf(
			"<a class='prev-page' href='%s'><span class='screen-reader-text'>%s</span><span aria-hidden='true'>%s</span></a>",
			esc_url(add_query_arg('paged', max(1, $current - 1), $current_url)),
			__('Previous page'),
			'&lsaquo;'
		);
	}

	$html_current_page = sprintf(
		"%s<input class='current-page' id='current-page-selector' type='text' name='paged' value='%s' size='%d' aria-describedby='table-paging' /><span class='tablenav-paging-text'>",
		'<label for="current-page-selector" class="screen-reader-text">' .
			__('Current Page') .
			'</label>',
		$current,
		strlen($total_pages)
	);

	$html_total_pages = sprintf(
		"<span class='total-pages'>%s</span>",
		number_format_i18n($total_pages)
	);

	$page_links[] =
		$total_pages_before .
		sprintf(
			_x('%1$s of %2$s', 'paging'),
			$html_current_page,
			$html_total_pages
		) .
		$total_pages_after;

	if ($disable_next) {
		$page_links[] =
			'<span class="tablenav-pages-navspan" aria-hidden="true">&rsaquo;</span>';
	} else {
		$page_links[] = sprintf(
			"<a class='next-page' href='%s'><span class='screen-reader-text'>%s</span><span aria-hidden='true'>%s</span></a>",
			esc_url(
				add_query_arg(
					'paged',
					min($total_pages, $current + 1),
					$current_url
				)
			),
			__('Next page'),
			'&rsaquo;'
		);
	}

	if ($disable_last) {
		$page_links[] =
			'<span class="tablenav-pages-navspan" aria-hidden="true">&raquo;</span>';
	} else {
		$page_links[] = sprintf(
			"<a class='last-page' href='%s'><span class='screen-reader-text'>%s</span><span aria-hidden='true'>%s</span></a>",
			esc_url(add_query_arg('paged', $total_pages, $current_url)),
			__('Last page'),
			'&raquo;'
		);
	}

	$pagination_links_class = 'pagination-links';

	if (!empty($infinite_scroll)) {
		$pagination_links_class = ' hide-if-js';
	}

	$output .=
		"\n<span class='$pagination_links_class'>" .
		join("\n", $page_links) .
		'</span>';

	if ($total_pages) {
		$page_class = $total_pages < 2 ? ' one-page' : '';
	} else {
		$page_class = ' no-pages';
	}

	add_thickbox();

	$arr_type_translate = array(
		'SALE' => 'Приход',
		'SALE_RETURN' => 'Возврат прихода',
		'PURCHASE' => 'Расход',
		'PURCHASE_RETURN' => 'Возврат расхода'
	);
	?>
	<style type="text/css">
	.wp-core-ui a.button.button-success{color:#fff;background-color:#46a546}.wp-core-ui a.button.button-success:hover,.wp-core-ui a.button.button-success:focus{background-color:#2f6f2f;color:#fff}.wp-core-ui a.button.button-inverse{color:#fff;background-color:#444}.wp-core-ui a.button.button-inverse:hover,.wp-core-ui a.button.button-inverse:focus{background-color:#1e1e1e;color:#fff}.wp-core-ui a.remove{color:darkred}.wp-core-ui a.remove:hover{color:#e45252}#TB_ajaxWindowTitle{background:#67B4F5;color:#fff;text-transform:uppercase}span.error{font-weight:700;letter-spacing:.1em;color:red}span.success{font-weight:700;letter-spacing:.1em;color:forestgreen}span.type{padding:4px 10px;border-radius:4px;color:white;background:green}span.type-error{opacity:.5}span.type.type-sale{background:forestgreen;color:white}span.type.type-sale_return{background:lightgreen;color:black}span.type.type-purchase{background:lightslategrey;color:white}span.type.type-purchase_return{background:lightslateblue;color:black}table#bifit td{vertical-align:middle}.wp-core-ui a.button.button-danger{color:#fff;background-color:#a54646;border-color:#a54646}.wp-core-ui a.button.button-danger:hover{background-color:#d45f5f;border-color:#d45f5f}
	</style>
	<div class="tablenav top">
		<div class="tablenav-pages<?php echo $page_class; ?>"><?php echo $output; ?></div>
	</div>
	<table id="bifit" class="wp-list-table widefat fixed striped posts">
		<thead>
			<tr>
				<th width="15">#</th>
				<th width="70">Заказ</th>				
				<th>Дата заказа</th>
				<th>Дата запроса</th>
				<th>Чек</th>
				<th>Документ</th>
				<th>Лог</th>
				<th>Тип</th>
				<th width="60" style="text-align:center;">Удалить</th>
			</tr>
		</thead>
		<tbody>
			<?php 
			foreach ($transactions as $key_id => $action):
				// added from the side (v.1.2.6)
				preg_match('/created: (.*?)\n/m', $transactions[$key_id]->log, $b);
				// /added from the side (v.1.2.6)
				$edit_link =
				$http .
				$_SERVER['HTTP_HOST'] .
				'/wp-admin/post.php?post=' .
				$action->order_id .
				'&action=edit'; 
				?>
				<tr>
					<td><?php echo $from + $key_id + 1; ?></td>
					<td><a target="_blank" class="order_number" href="<?php echo $edit_link; ?>">№<?php echo $action->order_number; ?></a></td>
					<td><span class="dashicons dashicons-calendar"></span> <?php 
					// added from the side (v.1.2.6)
					echo $action->order_date === "0000-00-00 00:00:00" 
						? date('Y-m-d H:i:s', substr($b[1], 0, -3)) 
						: $action->order_date; 
					// /added from the side (v.1.2.6)
					?></td>
					<td><span class="dashicons dashicons-calendar"></span> <?php echo isset($action->action_date) ? $action->action_date : $action->order_date; ?></td>
					<td><?php if ((int)$action->receipt_id > 0) {?>
							<a target="_blank" class="button button-small button-primary" href="<?php echo $action->receipt_link; ?>"><span class="dashicons dashicons-tickets"></span> Открыть</a>
						<?php } else {?>
							<span class="error">нет</span>
						<?php }?></td>
					<td><?php if ((int)$action->receipt_id > 0) {?>
							<span class="success"><span class="dashicons dashicons-tag"></span> <?php echo $action->receipt_id; ?></span>
						<?php } else {?>
							<span class="error"><span class="dashicons dashicons-warning"></span> нет</span>
						<?php }?></td>
					<td><a class="button button-small button-<?php echo (int)$action->receipt_id > 0 ? 'success' : 'danger'; ?> thickbox" href="/?TB_inline&width=600&height=550&inlineId=log<?php echo $key_id . $action->order_id; ?>" title="Протокол #<?php echo $action->receipt_id; ?>"><span class="dashicons dashicons-visibility"></span> Смотреть</a>
						<div id="log<?php echo $key_id . $action->order_id; ?>" style="display:none;">
							<div><?php echo str_replace(
								"\n",
								"<br>",
								$action->log
								); ?>
							</div>
						</div></td>
					<td>
						<span class="type type-<?php echo (int)$action->receipt_id > 0 ? 'success' : 'error'; ?> type-<?php echo strtolower($action->receipt_type); ?>"><?php echo $arr_type_translate[$action->receipt_type]; ?></span>						
					</td>
					<td style="text-align:center;"><a class="remove" href="<?php echo $current_url; ?>&del=<?php echo $action->id; ?>"><span class="dashicons dashicons-trash"></span></a></td>
				</tr>
				<?php
			endforeach; ?>
		</tbody>
		<tfoot>
			<tr>
				<td width="15">#</td>
				<td width="50">Заказ</td>
				<th>Дата заказа</th>
				<th>Дата запроса</th>
				<td>Чек</td>
				<td>Документ</td>
				<td>Лог</td>
				<td>Тип</td>
				<td width="60" style="text-align:center;">Удалить</td>
			</tr>
		</tfoot>
	</table>
</div>	