<?php

if (!defined('ABSPATH')) {
	exit();
}

$tabs = array(
	'general' => 'Основные',
	'sale' => 'Приход',
	'sale_return' => 'Возврат прихода',
	'purchase' => 'Расход',
	'purchase_return' => 'Возврат расхода'
);


if (function_exists("wc_get_order_statuses")) {
	$w = 1;
}

$current_tab = empty($_GET['tab']) ? 'general' : sanitize_title($_GET['tab']);

session_start();

if (!function_exists('bifit_show_message')) {
	function bifit_show_message()
	{
		if (!empty($_SESSION['bifit_save_message'])) {
			echo '<div id="setting-error-settings_updated" class="notice notice-success settings-error is-dismissible">';
			echo '<p><strong>' .
				$_SESSION['bifit_save_message'] .
				'</strong></p>';
			echo '</div>';
			unset($_SESSION['bifit_save_message']);
		}
	}
}

if (isset($_POST['save'])) {
	$http = isset($_SERVER['HTTPS']) ? 'https://' : 'http://';
	$current_url = set_url_scheme(
		$http . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']
	);
	$_SESSION['bifit_save_message'] = 'Параметры успешно сохранены!';
	wp_safe_redirect($current_url);
	exit();
}
?>
<div class="wrap">
	<h1><span style="color:#000000;font-weight:700;">БИФИТ <span style="color:#67AEF7;">Касса</span></span></h1>
	<?php if (function_exists('bifit_show_message')) {
		bifit_show_message();
	}?>
	<form method="POST" id="mainform" enctype="multipart/form-data">
		<nav class="nav-tab-wrapper">
			<?php foreach ($tabs as $name => $label):
				echo '<a href="' .
				admin_url('admin.php?page=bifit-settings&tab=' . $name) .
				'" class="nav-tab ' .
				($current_tab == $name ? 'nav-tab-active' : '') .
				'">' .
				$label .
				'</a>';
			endforeach; ?>
		</nav>
		<h1 class="screen-reader-text"><?php echo esc_html($tabs[$current_tab]); ?></h1>
		<?php do_action('bifit_settings_' . $current_tab); ?>
		<p class="submit">
			<?php if (empty($GLOBALS['hide_save_button'])): ?>
				<input name="save" class="button-primary" type="submit" value="Сохранить" />
			<?php endif; ?>
			<?php wp_nonce_field('bifit-settings'); ?>
		</p>
	</form>
</div>